/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.mgmt.initialization;

import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.mgmt.initialization.InitializationListener;
import com.tandbergtv.workflow.resourcemanager.mgmt.initialization.InitializationStrategy;
import com.tandbergtv.workflow.resourcemanager.mgmt.initialization.ResourceInitializationEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractBaseInitializationStrategy
implements InitializationStrategy {
    private Resource resource;
    private List<InitializationListener> listeners = new ArrayList<InitializationListener>();
    private Map<String, String> configuration = new HashMap<String, String>();

    public AbstractBaseInitializationStrategy() {
    }

    public AbstractBaseInitializationStrategy(Resource resource) {
        this.resource = resource;
    }

    @Override
    public synchronized void setResource(Resource resource) {
        this.resource = resource;
    }

    @Override
    public synchronized Resource getResource() {
        return this.resource;
    }

    @Override
    public synchronized Map<String, String> getConfiguration() {
        return this.configuration;
    }

    @Override
    public synchronized void setConfiguration(Map<String, String> configuration) {
        this.configuration.clear();
        if (configuration != null) {
            this.configuration.putAll(configuration);
        }
    }

    @Override
    public synchronized void addInitializationListener(InitializationListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeInitializationListener(InitializationListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireInitializationSuccessEvent(ResourceInitializationEvent event) {
        List<InitializationListener> listenerList = this.getListenerList();
        for (InitializationListener listener : listenerList) {
            listener.initializationSuccess(event);
        }
    }

    protected void fireInitializationFailureEvent(ResourceInitializationEvent event) {
        List<InitializationListener> listenerList = this.getListenerList();
        for (InitializationListener listener : listenerList) {
            listener.initializationFailure(event);
        }
    }

    protected synchronized List<InitializationListener> getListenerList() {
        return new ArrayList<InitializationListener>(this.listeners);
    }
}

