/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.internal;

import com.tandbergtv.workflow.resourcemanager.dataaccess.DataAccessObjectFactory;
import com.tandbergtv.workflow.resourcemanager.dataaccess.hibernate.HibernateDAOFactory;
import com.tandbergtv.workflow.resourcemanager.internal.IHibernatePersistenceService;
import com.tandbergtv.workflow.resourcemanager.internal.ResourceManagementService;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;

public class ResourceManagementPersistenceService
extends ResourceManagementService
implements IHibernatePersistenceService {
    private final SessionFactory sessionFactory;
    private DataAccessObjectFactory daoFactory;
    private static final Logger LOGGER = Logger.getLogger(ResourceManagementPersistenceService.class);

    public ResourceManagementPersistenceService(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public Session getCurrentSession() {
        return this.sessionFactory.getCurrentSession();
    }

    @Override
    public void beginTransaction(Session session) {
        session.getTransaction().begin();
    }

    @Override
    public void commitTransaction(Session session) {
        session.getTransaction().commit();
    }

    @Override
    public void rollbackTransaction(Session session) {
        try {
            Transaction transaction = session.getTransaction();
            transaction.rollback();
        }
        catch (RuntimeException ex) {
            LOGGER.error((Object)"Failed to roll back the transaction.", (Throwable)ex);
        }
    }

    @Override
    public DataAccessObjectFactory getDataAccessObjectFactory() {
        return this.daoFactory;
    }

    @Override
    public void start() {
        this.daoFactory = new HibernateDAOFactory(this.sessionFactory);
    }

    @Override
    public void stop() {
        this.daoFactory = null;
    }
}

