/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.service.concurrent;

import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.tandbergtv.workflow.core.service.internal.AbstractRecoverableFutureWrapper;
import com.tandbergtv.workflow.core.service.util.SchedulerUtils;
import java.util.concurrent.Callable;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;

public class RecoverableFutureWrapper<T>
extends AbstractRecoverableFutureWrapper<T, T>
implements ExecutionCallback<T> {
    private static final Logger LOGGER = Logger.getLogger(RecoverableFutureWrapper.class);
    private volatile ICompletableFuture<T> future;

    private RecoverableFutureWrapper() {
    }

    private void start() {
        this.future.andThen((ExecutionCallback)this);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning) ? super.cancel(mayInterruptIfRunning) : false;
    }

    public void onResponse(T response) {
        LOGGER.debug((Object)(this.serviceName + " - Queue Size: " + this.queueSize.decrementAndGet()));
        this.set(response);
        this.doCallback();
    }

    public void onFailure(Throwable t) {
        LOGGER.debug((Object)(this.serviceName + " - Queue Size: " + this.queueSize.decrementAndGet()));
        try {
            if (!this.shouldRecover(t) || this.recoveryCount >= this.maximumRetryAttempts) {
                if (this.recoveryCount >= this.maximumRetryAttempts) {
                    LOGGER.warn((Object)("Task: " + this.callable.toString() + " has exceeded " + this.maximumRetryAttempts + " attempts to recover, failing task."));
                }
                this.setException(t);
                this.doCallback();
                return;
            }
            String name = this.callable.toString();
            LOGGER.debug((Object)("Recovering task: " + name + ", rescheduling..."));
            final RecoverableFutureWrapper callback = this;
            this.recoveryScheduler.schedule(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    RecoverableFutureWrapper.this.future = (ICompletableFuture)SchedulerUtils.submitTask(RecoverableFutureWrapper.this.callable, RecoverableFutureWrapper.this.executorService, RecoverableFutureWrapper.this.clusterService);
                    RecoverableFutureWrapper.this.future.andThen(callback);
                    LOGGER.debug((Object)(RecoverableFutureWrapper.this.serviceName + " - Queue Size: " + RecoverableFutureWrapper.this.queueSize.incrementAndGet()));
                    RecoverableFutureWrapper.this.recoveryCount++;
                    return null;
                }
            });
        }
        catch (Exception e) {
            LOGGER.warn((Object)"error when recovering task", (Throwable)e);
            this.setException(e);
            this.doCallback();
        }
    }

    public void setFuture(ICompletableFuture<T> future) {
        this.future = future;
    }

    public static class RecoverableFutureBuilder<T>
    extends AbstractRecoverableFutureWrapper.Builder<RecoverableFutureBuilder<T>, RecoverableFutureWrapper<T>, T, T> {
        public RecoverableFutureBuilder<T> future(ICompletableFuture<T> future) {
            ((RecoverableFutureWrapper)this.wrapper).setFuture(future);
            return this;
        }

        @Override
        public RecoverableFutureWrapper<T> build() {
            Validate.notNull((Object)((RecoverableFutureWrapper)this.wrapper).callable);
            Validate.notNull((Object)((RecoverableFutureWrapper)this.wrapper).future);
            Validate.notNull((Object)((RecoverableFutureWrapper)this.wrapper).executorService);
            Validate.notNull((Object)((RecoverableFutureWrapper)this.wrapper).clusterService);
            Validate.notNull((Object)((RecoverableFutureWrapper)this.wrapper).recoveryScheduler);
            Validate.notEmpty((String)((RecoverableFutureWrapper)this.wrapper).serviceName);
            Validate.notNull((Object)((RecoverableFutureWrapper)this.wrapper).queueSize);
            ((RecoverableFutureWrapper)this.wrapper).start();
            return (RecoverableFutureWrapper)this.wrapper;
        }

        @Override
        protected RecoverableFutureWrapper<T> create() {
            return new RecoverableFutureWrapper();
        }

        @Override
        protected RecoverableFutureBuilder<T> getThis() {
            return this;
        }
    }
}

