/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.service.internal;

import com.google.common.util.concurrent.AbstractFuture;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.MemberLeftException;
import com.tandbergtv.workflow.core.service.cluster.IClusterService;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.ITaskCompletionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public abstract class AbstractRecoverableFutureWrapper<T, R>
extends AbstractFuture<R> {
    private static final Logger LOGGER = Logger.getLogger(AbstractRecoverableFutureWrapper.class);
    public static final int DEFAULT_MAXIMUM_RETRY = 10;
    protected Callable<T> callable;
    protected int recoveryCount = 0;
    protected ISchedulerService<Void> recoveryScheduler;
    protected IExecutorService executorService;
    protected IClusterService clusterService;
    protected final List<ITaskCompletionListener> listeners = new ArrayList<ITaskCompletionListener>(5);
    protected AtomicInteger queueSize;
    protected String serviceName;
    protected int maximumRetryAttempts = 10;
    protected final Set<Class<? extends Exception>> recoverableErrors = new CopyOnWriteArraySet<Class<? extends Exception>>();

    protected boolean shouldRecover(Throwable exception) {
        if (exception instanceof MemberLeftException) {
            return true;
        }
        if (exception instanceof ExecutionException) {
            return this.isRecoverableError(exception.getCause());
        }
        return false;
    }

    public boolean isRecoverableError(Throwable error) {
        for (Class<? extends Exception> errorClass : this.recoverableErrors) {
            if (!errorClass.isInstance(error)) continue;
            return true;
        }
        return false;
    }

    protected void doCallback() {
        for (ITaskCompletionListener listener : this.listeners) {
            try {
                listener.onTaskCompleted(this.callable, this);
            }
            catch (Exception e) {
                LOGGER.warn((Object)("error when calling listener: " + e.getLocalizedMessage()));
            }
        }
    }

    public void setCallable(Callable<T> callable) {
        this.callable = callable;
    }

    public void setRecoveryScheduler(ISchedulerService<Void> recoveryScheduler) {
        this.recoveryScheduler = recoveryScheduler;
    }

    public void setExecutorService(IExecutorService executorService) {
        this.executorService = executorService;
    }

    public void setClusterService(IClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public void setQueueSize(AtomicInteger queueSize) {
        this.queueSize = queueSize;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setMaximumRetryAttempts(int maximumRetryAttempts) {
        this.maximumRetryAttempts = maximumRetryAttempts;
    }

    public List<ITaskCompletionListener> getListeners() {
        return this.listeners;
    }

    public Set<Class<? extends Exception>> getRecoverableErrors() {
        return this.recoverableErrors;
    }

    public static abstract class Builder<B extends Builder<B, W, T1, R1>, W extends AbstractRecoverableFutureWrapper<T1, R1>, T1, R1> {
        protected W wrapper = this.create();

        protected Builder() {
        }

        public B callable(Callable<T1> callable) {
            ((AbstractRecoverableFutureWrapper)((Object)this.wrapper)).setCallable(callable);
            return this.getThis();
        }

        public B executorService(IExecutorService executorService) {
            ((AbstractRecoverableFutureWrapper)((Object)this.wrapper)).setExecutorService(executorService);
            return this.getThis();
        }

        public B clusterService(IClusterService clusterService) {
            ((AbstractRecoverableFutureWrapper)((Object)this.wrapper)).setClusterService(clusterService);
            return this.getThis();
        }

        public B recoveryScheduler(ISchedulerService<Void> recoveryScheduler) {
            ((AbstractRecoverableFutureWrapper)((Object)this.wrapper)).setRecoveryScheduler(recoveryScheduler);
            return this.getThis();
        }

        public B listeners(List<ITaskCompletionListener> listeners) {
            ((AbstractRecoverableFutureWrapper)((Object)this.wrapper)).getListeners().addAll(listeners);
            return this.getThis();
        }

        public B queueSize(AtomicInteger queueSize) {
            ((AbstractRecoverableFutureWrapper)((Object)this.wrapper)).setQueueSize(queueSize);
            return this.getThis();
        }

        public B serviceName(String serviceName) {
            ((AbstractRecoverableFutureWrapper)((Object)this.wrapper)).setServiceName(serviceName);
            return this.getThis();
        }

        public B maximumRetryAttempts(int maximumRetryAttempts) {
            ((AbstractRecoverableFutureWrapper)((Object)this.wrapper)).setMaximumRetryAttempts(maximumRetryAttempts);
            return this.getThis();
        }

        public B recoverableErrors(Set<Class<? extends Exception>> recoverableErrors) {
            ((AbstractRecoverableFutureWrapper)((Object)this.wrapper)).getRecoverableErrors().addAll(recoverableErrors);
            return this.getThis();
        }

        protected abstract W create();

        public abstract W build();

        protected abstract B getThis();
    }
}

