/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.rest.services.test;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.resourcemanager.DataOperationException;
import com.tandbergtv.workflow.resourcemanager.FinderException;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.rest.services.internal.ActivityResource;
import com.tandbergtv.workflow.rest.services.test.RESTServiceMockTestBase;
import com.tandbergtv.workflow.test.util.ProcessUtils;
import com.tandbergtv.workflow.test.util.ResourceUtils;
import com.tandbergtv.workflow.test.util.TestUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

@Test(groups={"sequential"})
public class ProcessActivityTest
extends RESTServiceMockTestBase {
    private static final String BASE_API_PATH = "/activity";
    private static final String HUMAN_RESOURCE_SYSTEM_ID = "04";
    private static final String ACTIVITY = "activity";
    private static final int DEFAULT_COUNT = 10;
    private static final String TEMPLATE_NAME = "loop-manual-task-template";
    private static final String CURRENT_NODE = "Manual Task In Loop";
    private static final String PROVIDERID_TEMPLATE = "UserTaskTemplate";
    private static final String PROVIDER_ID = "providerId";
    private static final String TIMEOUT_TEMPLATE = "basic-timeout-template";
    private static final String MISSING_PROVIDER_ID = "nevermind";

    public ProcessActivityTest() {
        super(ActivityResource.class);
    }

    @Test
    public void testActivityForProcessesUsingResource() throws Exception {
        this.setResourceGroupsVisiblity(HUMAN_RESOURCE_SYSTEM_ID, true);
        List<String> resourcesNameBySystemId = this.getResourceNamesByResourceTypeSystemId(HUMAN_RESOURCE_SYSTEM_ID);
        this.createBusyProcesses(11);
        TimeUnit.SECONDS.sleep(15L);
        List<Map<String, Object>> activityList = this.getResourcesList("http://localhost:8081/activity", ACTIVITY);
        ProcessActivityTest.assertEquals((int)activityList.size(), (int)10);
        ProcessActivityTest.assertTrue((boolean)this.isOrderedDescending(this.getStartDates(activityList)));
        for (int i = 0; i < activityList.size(); ++i) {
            ProcessActivityTest.assertTrue((boolean)activityList.get(i).get("template").toString().startsWith(TEMPLATE_NAME), (String)("actual value is " + activityList.get(i).get("template")));
            ProcessActivityTest.assertEquals((Object)activityList.get(i).get("status"), (Object)ProcessStatus.BUSY.name());
            ProcessActivityTest.assertEquals((Object)activityList.get(i).get("adminstatus"), (Object)ProcessStatus.RUNNING.name());
            ProcessActivityTest.assertEquals((Object)activityList.get(i).get("priority"), (Object)ProcessPriority.P10.name());
            ProcessActivityTest.assertEquals((Object)activityList.get(i).get("current"), (Object)CURRENT_NODE);
            ProcessActivityTest.assertTrue((boolean)resourcesNameBySystemId.contains(activityList.get(i).get("resource")));
            ProcessActivityTest.assertTrue((boolean)activityList.get(i).containsKey("resourceId"));
            ProcessActivityTest.assertTrue((boolean)activityList.get(i).containsKey("progress"));
        }
    }

    @Test
    public void testActivityForProcessesAssociatedWithInvisibleGroup() throws Exception {
        this.setResourceGroupsVisiblity(HUMAN_RESOURCE_SYSTEM_ID, false);
        this.createBusyProcesses(2);
        TimeUnit.SECONDS.sleep(30L);
        List<Map<String, Object>> activityList = this.getResourcesList("http://localhost:8081/activity", ACTIVITY);
        ProcessActivityTest.assertTrue((boolean)activityList.isEmpty());
    }

    @Test
    public void testActivityForProcessesNotUsingResources() throws Exception {
        String uuid = this.createActiveProcesesNotUsingResource();
        List<Map<String, Object>> activityList = this.getResourcesList("http://localhost:8081/activity?providerId=" + uuid, ACTIVITY);
        ProcessActivityTest.assertTrue((boolean)activityList.isEmpty());
    }

    @Test
    public void testFilterByProviderId() throws Exception {
        String uuid = UUID.randomUUID().toString();
        this.createBusyProcesses(1);
        WorkflowProcess process = this.run(PROVIDERID_TEMPLATE, Collections.singletonMap(PROVIDER_ID, uuid));
        ProcessUtils.sleepUntilStatus(process.getId(), 60000L, ProcessStatus.BUSY);
        TimeUnit.SECONDS.sleep(30L);
        List<Map<String, Object>> activityList = this.getResourcesList("http://localhost:8081/activity?providerId=" + uuid, ACTIVITY);
        ProcessActivityTest.assertEquals((int)activityList.size(), (int)1);
        ProcessActivityTest.assertEquals((Object)activityList.get(0).get(PROVIDER_ID), (Object)uuid);
        ProcessActivityTest.assertTrue((boolean)activityList.get(0).get("template").toString().startsWith(PROVIDERID_TEMPLATE));
        List<Map<String, Object>> missingProviderActivityList = this.getResourcesList("http://localhost:8081/activity?providerId=nevermind", ACTIVITY);
        ProcessActivityTest.assertTrue((boolean)missingProviderActivityList.isEmpty());
    }

    private void createBusyProcesses(int count) throws Exception {
        for (int i = 0; i < count; ++i) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("manualVariableList", new ArrayList(Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4"})));
            WorkflowProcess process = this.run(TEMPLATE_NAME, params);
            ProcessUtils.sleepUntilStatus(process.getId(), 60000L, ProcessStatus.BUSY);
        }
    }

    private String createActiveProcesesNotUsingResource() throws Exception {
        String uuid = UUID.randomUUID().toString();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("timeout", "60000");
        params.put(PROVIDER_ID, uuid);
        WorkflowProcess process = this.run(TIMEOUT_TEMPLATE, params);
        ProcessUtils.sleepUntilStatus(process.getId(), 60000L, ProcessStatus.BUSY);
        return uuid;
    }

    private void setResourceGroupsVisiblity(String systemId, boolean isVisible) throws FinderException, DataOperationException {
        for (ResourceGroup group : this.getResourceGroups(HUMAN_RESOURCE_SYSTEM_ID)) {
            if (!"Human".equals(group.getName())) continue;
            TestUtil.getResourceManagement().setResourceGroupQueueUIVisibility(group.getId(), isVisible);
        }
    }

    private boolean isOrderedDescending(ArrayList<Long> arrayList) {
        return Ordering.natural().reverse().isOrdered(arrayList);
    }

    private ArrayList<Long> getStartDates(List<Map<String, Object>> resources) throws Exception {
        return new ArrayList<Long>(Lists.transform(resources, this.startDateMapper()));
    }

    private Function<Map<String, Object>, Long> startDateMapper() {
        return new Function<Map<String, Object>, Long>(){

            public Long apply(Map<String, Object> map) {
                try {
                    return new SimpleDateFormat("yyy-MM-dd HH:mm:ss").parse(map.get("start").toString()).getTime();
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        };
    }

    private List<ResourceGroup> getResourceGroups(String systemId) {
        return ResourceUtils.getResourceGroupsByResourceTypeSystemId(systemId);
    }

    private List<String> getResourceNamesByResourceTypeSystemId(String systemId) {
        ArrayList<String> resourcesName = new ArrayList<String>();
        for (ResourceGroup group : this.getResourceGroups(systemId)) {
            if (!"Human".equals(group.getName())) continue;
            for (Resource resource : TestUtil.getResourceManagement().getResourcesByGroup(group.getId())) {
                resourcesName.add(resource.getName());
            }
            return resourcesName;
        }
        return Collections.emptyList();
    }
}

