/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.rest.services.test;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.driver.DriverException;
import com.tandbergtv.workflow.driver.ProcessFinder;
import com.tandbergtv.workflow.rest.services.internal.ProcessesResource;
import com.tandbergtv.workflow.rest.services.test.AbstractQueryBuilder;
import com.tandbergtv.workflow.rest.services.test.ProcessQueryBuilder;
import com.tandbergtv.workflow.rest.services.test.RESTServiceMockTestBase;
import com.tandbergtv.workflow.rest.services.test.RESTUtil;
import com.tandbergtv.workflow.test.util.ProcessUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.codehaus.jackson.JsonProcessingException;
import org.testng.annotations.Test;

@Test(groups={"sequential"})
public class ProcessesTest
extends RESTServiceMockTestBase {
    private static final String PROVIDER_ID = "providerId";
    private static final String TEMPLATE = "FailureTemplate";
    private static final String PROVIDERID_TEMPLATE = "UserTaskTemplate";
    private static final String MISSING_TEMPLATE = "__nevermind__";
    private static final int PROCESSES_COUNT = 10;
    private static final String ENDPOINT_PATH = "processes";
    private static final String FIELD_NAME = "processes";
    private static final String INVALID_STARTDATE_QUERY = "&startDate=nevermind";
    private static final String INVALID_START_QUERY = "&start=nevermind";
    private static final String INVALID_STATUS_QUERY = "&status=nevermind";
    private static final String INVALID_COUNT_QUERY = "&count=-1";
    private static final String MISSING_TITLEID = "nevermind";
    private static final String MISSING_PROVIDERID = "nevermind";

    public ProcessesTest() {
        super(ProcessesResource.class);
    }

    @Test
    public void filterByTemplateStartStatus() throws Exception {
        this.create(TEMPLATE, 10);
        TimeUnit.SECONDS.sleep(60L);
        ProcessesTest.assertEquals((int)this.queryStatus(this.queryBuilder()), (int)200);
        List<Map<String, Object>> resources = this.doQuery(this.templateStatusStartQuery().count(15));
        ProcessesTest.assertEquals((int)resources.size(), (int)10);
        ProcessesTest.assertTrue((boolean)this.isOrderedDescending(this.getIds(resources)));
        resources = this.doQuery(this.templateStatusStartQuery().count(5).order("asc"));
        ProcessesTest.assertEquals((int)resources.size(), (int)5);
        ProcessesTest.assertTrue((boolean)this.isOrdered(this.getIds(resources)));
        resources = this.doQuery(this.templateStatusStartQuery().start(10));
        ProcessesTest.assertTrue((boolean)resources.isEmpty());
        Map<String, Object> pagingMap = this.getResponseMap(this.templateStatusStartQuery().start(0).count(5).build());
        ProcessesTest.assertNull((Object)pagingMap.get("first"));
        ProcessesTest.assertNull((Object)pagingMap.get("prev"));
        ProcessesTest.assertNotNull((Object)pagingMap.get("next"));
        pagingMap = this.getResponseMap(this.templateStatusStartQuery().start(5).count(5).build());
        ProcessesTest.assertNotNull((Object)pagingMap.get("first"));
        ProcessesTest.assertNotNull((Object)pagingMap.get("prev"));
        ProcessesTest.assertNull((Object)pagingMap.get("next"));
    }

    @Test
    public void filterByProviderId() throws Exception {
        String uuid = UUID.randomUUID().toString();
        this.create(PROVIDERID_TEMPLATE, Collections.singletonMap(PROVIDER_ID, uuid));
        TimeUnit.SECONDS.sleep(30L);
        List<Map<String, Object>> resources = this.doQuery(this.providerIdQuery(uuid).detail("summary"));
        ProcessesTest.assertEquals((int)resources.size(), (int)1);
        ProcessesTest.assertEquals((Object)resources.get(0).get(PROVIDER_ID), (Object)uuid);
        ProcessesTest.assertTrue((boolean)resources.get(0).get("template").toString().startsWith(PROVIDERID_TEMPLATE));
    }

    @Test
    public void filterByTitleIdNoResults() throws Exception {
        ProcessesTest.assertTrue((boolean)this.doQuery(this.missingTitleIdQuery()).isEmpty());
    }

    @Test
    public void filterByMissingTemplateNoResults() throws Exception {
        ProcessesTest.assertTrue((boolean)this.doQuery(this.missingTemplateQuery()).isEmpty());
    }

    @Test
    public void filterByProviderIdNoResults() throws Exception {
        ProcessesTest.assertTrue((boolean)this.doQuery(this.missingProviderIdQuery()).isEmpty());
    }

    @Test
    public void filterByInvalidStatusFails() throws Exception {
        ProcessesTest.assertEquals((int)this.queryStatus(INVALID_STATUS_QUERY), (int)400);
    }

    @Test
    public void filterByInvalidStartDateFails() throws Exception {
        ProcessesTest.assertEquals((int)this.queryStatus(INVALID_STARTDATE_QUERY), (int)400);
    }

    @Test
    public void pagingInvalidStartFails() throws Exception {
        ProcessesTest.assertEquals((int)this.queryStatus(INVALID_START_QUERY), (int)400);
    }

    @Test
    public void pagingInvalidCountFails() throws Exception {
        ProcessesTest.assertEquals((int)this.queryStatus(INVALID_COUNT_QUERY), (int)400);
    }

    private AbstractQueryBuilder templateStatusStartQuery() {
        return this.queryBuilder().template(TEMPLATE).startDate(new Date()).status(ProcessStatus.PAUSED);
    }

    private AbstractQueryBuilder providerIdQuery(String providerId) {
        return this.queryBuilder().providerId(providerId).startDate(new Date());
    }

    private AbstractQueryBuilder missingTemplateQuery() {
        return this.queryBuilder().template(MISSING_TEMPLATE).startDate(new Date());
    }

    private AbstractQueryBuilder missingTitleIdQuery() {
        return this.queryBuilder().titleId("nevermind").startDate(new Date());
    }

    private AbstractQueryBuilder missingProviderIdQuery() {
        return this.queryBuilder().providerId("nevermind").startDate(new Date());
    }

    private boolean isOrdered(List<Long> ids) {
        return Ordering.natural().isStrictlyOrdered(ids);
    }

    private boolean isOrderedDescending(List<Long> ids) {
        return Ordering.natural().reverse().isStrictlyOrdered(ids);
    }

    private ProcessQueryBuilder queryBuilder() {
        return new ProcessQueryBuilder("http://localhost:8081");
    }

    private void create(String template, int n) {
        for (int i = 0; i < n; ++i) {
            try {
                this.create(template);
                continue;
            }
            catch (DriverException driverException) {
                // empty catch block
            }
        }
    }

    private List<Long> getIds(List<Map<String, Object>> resources) {
        return new ArrayList<Long>(Lists.transform(resources, this.idMapper()));
    }

    private Function<Map<String, Object>, Long> idMapper() {
        return new Function<Map<String, Object>, Long>(){

            public Long apply(Map<String, Object> map) {
                return ((Number)Number.class.cast(map.get("id"))).longValue();
            }
        };
    }

    private WorkflowProcess create(String template) throws DriverException {
        return this.create(template, new HashMap<String, Object>());
    }

    private WorkflowProcess create(String template, Map<String, Object> parameters) throws DriverException {
        WorkflowProcess process = ProcessUtils.createIdle(template, parameters);
        this.getCreatedProcesses().add(process);
        ProcessFinder.updateOwner((WorkflowProcess)process);
        this.getCache().add((Serializable)Long.valueOf(process.getId()), (Object)process);
        ProcessUtils.pause(process);
        return process;
    }

    private ICacheService<WorkflowProcess> getCache() {
        return (ICacheService)ServiceRegistry.getDefault().lookup("Process Cache");
    }

    private List<Map<String, Object>> doQuery(AbstractQueryBuilder builder) throws JsonProcessingException, IOException {
        return this.getResourcesList(builder.build(), "processes");
    }

    private int queryStatus(AbstractQueryBuilder builder) {
        return this.executeGet(builder.build(), RESTUtil.setDefaultHeaders()).getStatus();
    }

    private int queryStatus(String url) {
        return this.executeGet("http://localhost:8081/processes?" + url, RESTUtil.setDefaultHeaders()).getStatus();
    }
}

