/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.clusternode;

import com.tandbergtv.workflow.clusternode.GetAverageResponseTimeCallable;
import com.tandbergtv.workflow.clusternode.ResponseTimeCallable;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"normal"})
public class ResponseTimeTest
extends Assert {
    private static final String SERVICE_NAME = "timing-monitor";
    private static final Long DELAY_1 = 100L;
    private static final Long DELAY_2 = 500L;
    private static final Long AVG_DELAY = 220L;
    private static final String NAME = "fd89da3a15c504b7455fab5e19ee0ef0";

    @BeforeTest
    void setup() throws Exception {
        this.addSample(DELAY_1);
        this.addSample(DELAY_2);
    }

    @Test
    void testResponseTime() throws Exception {
        Assert.assertEquals((long)this.getAverage(), (long)AVG_DELAY, (String)"Unexpected response time");
    }

    void addSample(long delay) throws Exception {
        this.scheduler().schedule((Callable)((Object)new ResponseTimeCallable(NAME, delay))).get(10L, TimeUnit.SECONDS);
    }

    Long getAverage() throws Exception {
        return (Long)this.scheduler2().schedule((Callable)((Object)new GetAverageResponseTimeCallable())).get(10L, TimeUnit.SECONDS);
    }

    ISchedulerService<Long> scheduler2() {
        return (ISchedulerService)ServiceRegistry.getDefault().lookup(SERVICE_NAME);
    }

    ISchedulerService<Void> scheduler() {
        return (ISchedulerService)ServiceRegistry.getDefault().lookup(SERVICE_NAME);
    }
}

