/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.rest.services.test;

import com.tandbergtv.workflow.auth.domain.ProtectionKey;
import com.tandbergtv.workflow.core.Selector;
import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import com.tandbergtv.workflow.rest.services.internal.TemplatesResource;
import com.tandbergtv.workflow.rest.services.test.MockRequestType;
import com.tandbergtv.workflow.rest.services.test.RESTServiceMockTestBase;
import com.tandbergtv.workflow.rest.services.test.RESTUtil;
import com.tandbergtv.workflow.test.util.TestUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.jboss.resteasy.mock.MockHttpResponse;
import org.testng.annotations.Test;

@Test(groups={"normal"})
public class TemplateResourceTest
extends RESTServiceMockTestBase {
    private static final String DEFAULT_TEMPLATE = "variable-default-value-assigned-template";
    private static final String SELECTOR_KEY_TEMPLATE = "blank-template";
    private static final String ANNOTATIONS_TEMPLATE = "Title Distribution";
    private static final String RESOURCE_GROUPS_TEMPLATE = "list-index-superstate-template";
    private static final String BASE_API_PATH = "/templates/";
    private static final String VERSION = "X-API-Version";
    private static final String SELECTORS = "selectors";
    private static final String PROTECTION_KEYS = "protectionKeys";
    private static final String ANNOTATIONS = "annotations";
    private static final String VARIABLES = "variables";
    private static final String RESOURCE_GROUPS = "resourceGroups";

    public TemplateResourceTest() {
        super(TemplatesResource.class);
    }

    @Test
    public void testTemplateGetForVariables() throws Exception {
        WorkflowTemplate template = TestUtil.getService(ITemplateLoaderService.class).getTemplateByName(DEFAULT_TEMPLATE);
        String uri = BASE_API_PATH + template.getId();
        MockHttpResponse response = this.execute(uri, RESTUtil.setDefaultHeaders(), MockRequestType.GET);
        TemplateResourceTest.assertEquals((int)response.getStatus(), (int)200);
        this.verifyResponseFields(response, template);
    }

    @Test
    public void testTemplateGetForSelectors() throws Exception {
        WorkflowTemplate template = TestUtil.getService(ITemplateLoaderService.class).getTemplateByName(SELECTOR_KEY_TEMPLATE);
        template.addSelectorKey(new Selector("selectorKey1"));
        template.addSelectorKey(new Selector("selectorKey2"));
        String uri = BASE_API_PATH + template.getId();
        MockHttpResponse response = this.execute(uri, RESTUtil.setDefaultHeaders(), MockRequestType.GET);
        TemplateResourceTest.assertEquals((int)response.getStatus(), (int)200);
        this.verifyResponseFields(response, template);
    }

    @Test
    public void testTemplateGetForAnnotations() throws Exception {
        WorkflowTemplate template = TestUtil.getService(ITemplateLoaderService.class).getTemplateByName(ANNOTATIONS_TEMPLATE);
        String uri = BASE_API_PATH + template.getId();
        MockHttpResponse response = this.execute(uri, RESTUtil.setDefaultHeaders(), MockRequestType.GET);
        TemplateResourceTest.assertEquals((int)response.getStatus(), (int)200);
        this.verifyResponseFields(response, template);
    }

    @Test
    public void testTemplateGetForResourceGroups() throws Exception {
        WorkflowTemplate template = TestUtil.getService(ITemplateLoaderService.class).getTemplateByName(RESOURCE_GROUPS_TEMPLATE);
        String uri = BASE_API_PATH + template.getId();
        MockHttpResponse response = this.execute(uri, RESTUtil.setDefaultHeaders(), MockRequestType.GET);
        TemplateResourceTest.assertEquals((int)response.getStatus(), (int)200);
        this.verifyResponseFields(response, template);
        this.verifyResourceGroups(response);
    }

    @Test
    public void testWhenNoVersionHeaderIsSent() throws Exception {
        WorkflowTemplate template = TestUtil.getService(ITemplateLoaderService.class).getTemplateByName(DEFAULT_TEMPLATE);
        String uri = BASE_API_PATH + template.getId();
        MockHttpResponse response = this.execute(uri, new HashMap<String, String>(), MockRequestType.GET);
        TemplateResourceTest.assertEquals((int)response.getStatus(), (int)412);
    }

    @Test
    public void testInvalidVersionHeader() throws Exception {
        WorkflowTemplate template = TestUtil.getService(ITemplateLoaderService.class).getTemplateByName(DEFAULT_TEMPLATE);
        String uri = BASE_API_PATH + template.getId();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(VERSION, "2");
        MockHttpResponse response = this.execute(uri, headers, MockRequestType.GET);
        TemplateResourceTest.assertEquals((int)response.getStatus(), (int)412);
    }

    @Test
    public void testTemplateNotFound() throws Exception {
        String uri = "/templates/0";
        MockHttpResponse response = this.execute(uri, RESTUtil.setDefaultHeaders(), MockRequestType.GET);
        TemplateResourceTest.assertEquals((int)response.getStatus(), (int)404);
    }

    private List<String> getProtectionKeys(Collection<ProtectionKey> protectionKeys) {
        ArrayList<String> keys = new ArrayList<String>();
        for (ProtectionKey key : protectionKeys) {
            keys.add(key.getName());
        }
        return keys;
    }

    private List<String> getSelectorKeys(Collection<Selector> selectors) {
        ArrayList<String> selectorKeys = new ArrayList<String>();
        for (Selector selector : selectors) {
            selectorKeys.add(selector.getSelectionKey());
        }
        return selectorKeys;
    }

    private void verifyResponseFields(MockHttpResponse response, WorkflowTemplate template) throws JsonParseException, JsonMappingException, IOException {
        this.verifySingleValueFieldsInResponse(RESTUtil.deserialize(response), template);
        this.verifyProtectionKeys(response, template);
        this.verifySelectorKeys(response, template);
        this.verifyAnnotations(response, template);
        this.verifyTaskVariables(response, template);
    }

    private void verifySingleValueFieldsInResponse(Map<String, Object> responseMap, WorkflowTemplate template) throws JsonParseException, JsonMappingException, IOException {
        TemplateResourceTest.assertEquals((Object)responseMap.get("id"), (Object)String.valueOf(template.getId()));
        TemplateResourceTest.assertEquals((Object)responseMap.get("href"), (Object)("http://localhost:8081/templates/" + template.getId()));
        TemplateResourceTest.assertEquals((Object)responseMap.get("name"), (Object)template.getName());
        TemplateResourceTest.assertEquals((Object)responseMap.get("version"), (Object)template.getVersion());
        TemplateResourceTest.assertTrue((boolean)responseMap.containsKey("uuid"));
    }

    private void verifyProtectionKeys(MockHttpResponse response, WorkflowTemplate template) throws JsonParseException, JsonMappingException, IOException {
        TemplateResourceTest.assertTrue((boolean)RESTUtil.getFieldValues(response.getContentAsString(), PROTECTION_KEYS).containsAll(this.getProtectionKeys(template.getProtectionKeys())));
    }

    private void verifySelectorKeys(MockHttpResponse response, WorkflowTemplate template) throws JsonParseException, JsonMappingException, IOException {
        TemplateResourceTest.assertTrue((boolean)RESTUtil.getFieldValues(response.getContentAsString(), SELECTORS).containsAll(this.getSelectorKeys(template.getSelectorKeys())));
    }

    private void verifyAnnotations(MockHttpResponse response, WorkflowTemplate template) throws JsonParseException, JsonMappingException, IOException {
        TemplateResourceTest.assertTrue((boolean)RESTUtil.getFieldValues(response.getContentAsString(), ANNOTATIONS).containsAll(template.getAnnotations()));
    }

    private void verifyTaskVariables(MockHttpResponse response, WorkflowTemplate template) throws JsonParseException, JsonMappingException, IOException {
        List<Map<String, Object>> variablesListMap = RESTUtil.getComplexFieldValues(response.getContentAsString(), VARIABLES);
        TemplateResourceTest.assertTrue((variablesListMap.size() == template.getStartTaskVariables().size() ? 1 : 0) != 0);
        for (TaskVariable variable : template.getStartTaskVariables()) {
            boolean foundMatch = false;
            for (Map<String, Object> variablesMap : variablesListMap) {
                if (!variablesMap.get("name").equals(variable.getVariableName())) continue;
                foundMatch = true;
                TemplateResourceTest.assertEquals((Object)variablesMap.get("type"), (Object)variable.getDatatype().name());
                TemplateResourceTest.assertEquals((Object)variablesMap.get("displayname"), (Object)variable.getMappedName());
                if (variable.hasValue()) {
                    TemplateResourceTest.assertEquals((Object)variablesMap.get("value"), (Object)variable.getInitialValue());
                } else {
                    TemplateResourceTest.assertEquals((Object)variablesMap.get("value"), (Object)"");
                }
                TemplateResourceTest.assertEquals((Object)variablesMap.get("required"), (Object)variable.isRequired());
            }
            if (foundMatch) continue;
            TemplateResourceTest.fail((String)("The Response was missing a task variable entry with name " + variable.getVariableName()));
        }
    }

    private void verifyResourceGroups(MockHttpResponse response) throws JsonParseException, JsonMappingException, IOException {
        List<Map<String, Object>> groupsList = RESTUtil.getComplexFieldValues(response.getContentAsString(), RESOURCE_GROUPS);
        TemplateResourceTest.assertEquals((int)groupsList.size(), (int)2);
        for (Map<String, Object> group : groupsList) {
            TemplateResourceTest.assertTrue((boolean)group.containsKey("id"));
            TemplateResourceTest.assertTrue((boolean)group.containsKey("name"));
            TemplateResourceTest.assertTrue((boolean)group.containsKey("href"));
            TemplateResourceTest.assertTrue((boolean)group.containsKey("queueSize"));
            TemplateResourceTest.assertTrue((group.containsValue("Echo") || group.containsValue("Assert") ? 1 : 0) != 0);
            TemplateResourceTest.assertEquals((Object)group.get("href"), (Object)("http://localhost:8081/resourceGroups/" + group.get("id")));
        }
    }
}

