/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log.test;

import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.ILogWriter;
import com.tandbergtv.workflow.log.LogConverterService;
import com.tandbergtv.workflow.log.WorkflowLogService;
import com.tandbergtv.workflow.log.entities.MessageLog;
import com.tandbergtv.workflow.log.entities.ProcessQueuedPerResourceLog;
import com.tandbergtv.workflow.log.entities.ProcessStatusPerResourceLog;
import com.tandbergtv.workflow.log.file.LogReader;
import com.tandbergtv.workflow.log.file.ZipUtil;
import com.tandbergtv.workflow.test.NormalTestBase;
import com.tandbergtv.workflow.test.util.ESTransportClient;
import com.tandbergtv.workflow.test.util.ProcessUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHitField;
import org.jbpm.graph.log.NodeLog;
import org.jbpm.logging.log.ProcessLog;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test
public class HistoryLogESStorageTest
extends NormalTestBase {
    private static final int WAIT_FOR_ELASTICSEARCH = 20;
    private static final File SINGLE_INDEX_PROCESS_LOGS_FILE = new File("resources/historyLogs/2030074.zip");
    private static final String SINGLE_INDEX_PROCESSID = "2030074";
    private static final String SINGLE_INDEX_DATE = "2016-01-29";
    private static final File MULTIPLE_INDICES_PROCESS_LOGS_FILE = new File("resources/historyLogs/2039701.zip");
    private static final String MULTIPLE_INDICES_PROCESSID = "2039701";
    private static final String MULTIPLE_INDICES_DATE1 = "2016-02-02";
    private static final String MULTIPLE_INDICES_DATE2 = "2016-02-03";
    private String TEMPLATE = "loop-call-resource-template";
    private static final String INDEX_PREFIX = "history_logs_";
    private static final String PROCESS_ID = "processId";
    private static final long READ_TIMEOUT_MS = 30000L;
    private static final String LOG_TYPE = "logType";
    private static final String NODE_LOG_TYPE = "nodeLog";
    private static final String MESSAGE_LOG_TYPE = "messageLog";
    private static final String RESOURCE_LOG_TYPE = "resourceLog";
    private TransportClient client;
    private WorkflowLogService wflService;
    private LogReader logReader;

    @BeforeClass
    protected void setup() throws IOException {
        this.client = ESTransportClient.getTransportClient();
        this.wflService = (WorkflowLogService)ServiceRegistry.getDefault().lookup(WorkflowLogService.class);
        this.logReader = new LogReader(this.client);
    }

    @AfterClass
    protected void cleanup() throws IOException {
        this.deleteIndexFromES(SINGLE_INDEX_DATE);
        this.deleteIndexFromES(MULTIPLE_INDICES_DATE1);
        this.deleteIndexFromES(MULTIPLE_INDICES_DATE2);
        this.client.close();
    }

    @Test
    public void testHistoryLogWriteToES() throws Exception {
        WorkflowProcess wp = this.run(this.TEMPLATE);
        HistoryLogESStorageTest.assertTrue((boolean)ProcessUtils.sleepUntilComplete(wp.getId(), 60000L));
        TimeUnit.SECONDS.sleep(20L);
        int totalNodeLogs = this.wflService.getNodeLogCount(wp.getProcessDefinition(), wp.getId());
        int totalmessageLogs = this.logReader.getLogs(wp.getId(), MessageLog.class).size();
        int totalResourceLogs = this.logReader.getLogs(wp.getId(), ProcessStatusPerResourceLog.class).size();
        HistoryLogESStorageTest.assertEquals((int)totalNodeLogs, (int)9);
        HistoryLogESStorageTest.assertEquals((int)totalmessageLogs, (int)8);
        HistoryLogESStorageTest.assertEquals((int)totalResourceLogs, (int)8);
    }

    @Test
    public void testZipFileESSave() throws Exception {
        List logs = ZipUtil.read((File)SINGLE_INDEX_PROCESS_LOGS_FILE);
        int totalFilesForProcess = logs.size();
        Map<String, Integer> logsCountOnFS = this.getLogCountOnFS(logs);
        this.saveLogsInES(logs, SINGLE_INDEX_PROCESSID);
        SearchResponse resp = this.getSearchResult(SINGLE_INDEX_DATE, SINGLE_INDEX_PROCESSID, totalFilesForProcess);
        HistoryLogESStorageTest.assertEquals((long)resp.getHits().totalHits(), (long)totalFilesForProcess);
        int totalNodeLogsInES = this.logCount(resp, NODE_LOG_TYPE);
        int totalMessageLogsInES = this.logCount(resp, MESSAGE_LOG_TYPE);
        int totalResourceLogsInES = this.logCount(resp, RESOURCE_LOG_TYPE);
        HistoryLogESStorageTest.assertEquals((int)totalNodeLogsInES, (int)logsCountOnFS.get(NODE_LOG_TYPE));
        HistoryLogESStorageTest.assertEquals((int)totalMessageLogsInES, (int)logsCountOnFS.get(MESSAGE_LOG_TYPE));
        HistoryLogESStorageTest.assertEquals((int)totalResourceLogsInES, (int)logsCountOnFS.get(RESOURCE_LOG_TYPE));
    }

    @Test
    public void testZipFileESSaveProcssLogsAcrossIndices() throws Exception {
        List logs = ZipUtil.read((File)MULTIPLE_INDICES_PROCESS_LOGS_FILE);
        int totalFilesForProcess = logs.size();
        Map<String, Integer> logsCountOnFS = this.getLogCountOnFS(logs);
        this.saveLogsInES(logs, MULTIPLE_INDICES_PROCESSID);
        SearchResponse resp = this.getSearchResult(MULTIPLE_INDICES_DATE1, MULTIPLE_INDICES_PROCESSID, totalFilesForProcess);
        HistoryLogESStorageTest.assertEquals((long)resp.getHits().totalHits(), (long)(totalFilesForProcess - 1));
        int totalNodeLogsInES = this.logCount(resp, NODE_LOG_TYPE);
        int totalMessageLogsInES = this.logCount(resp, MESSAGE_LOG_TYPE);
        int totalResourceLogsInES = this.logCount(resp, RESOURCE_LOG_TYPE);
        HistoryLogESStorageTest.assertEquals((int)totalNodeLogsInES, (int)(logsCountOnFS.get(NODE_LOG_TYPE) - 1));
        HistoryLogESStorageTest.assertEquals((int)totalMessageLogsInES, (int)logsCountOnFS.get(MESSAGE_LOG_TYPE));
        HistoryLogESStorageTest.assertEquals((int)totalResourceLogsInES, (int)logsCountOnFS.get(RESOURCE_LOG_TYPE));
        resp = this.getSearchResult(MULTIPLE_INDICES_DATE2, MULTIPLE_INDICES_PROCESSID, totalFilesForProcess);
        HistoryLogESStorageTest.assertEquals((long)resp.getHits().totalHits(), (long)1L);
        HistoryLogESStorageTest.assertTrue((boolean)this.getStringField(resp.getHits().getAt(0), LOG_TYPE).equals(NODE_LOG_TYPE));
    }

    private String getStringField(SearchHit hit, String fieldName) {
        SearchHitField field = hit.field(fieldName);
        Object value = field == null ? null : field.getValue();
        return value == null ? "" : value.toString();
    }

    private void deleteIndexFromES(String index) {
        this.client.admin().indices().delete(new DeleteIndexRequest(INDEX_PREFIX + index)).actionGet();
    }

    private int logCount(SearchResponse response, String type) {
        int logCount = 0;
        for (SearchHit hit : response.getHits().hits()) {
            if (!this.getStringField(hit, LOG_TYPE).equals(type)) continue;
            ++logCount;
        }
        return logCount;
    }

    private SearchResponse getSearchResult(String index, String id, int size) {
        SearchRequestBuilder bld = this.client.prepareSearch(new String[]{INDEX_PREFIX + index});
        SearchResponse resp = (SearchResponse)bld.setQuery((QueryBuilder)QueryBuilders.matchQuery((String)PROCESS_ID, (Object)id)).setSize(size).addField(LOG_TYPE).execute().actionGet(30000L);
        return resp;
    }

    private void saveLogsInES(List<ProcessLog> logs, String id) throws Exception {
        for (ProcessLog log : logs) {
            Map logMap;
            ILogWriter writerService = (ILogWriter)ServiceRegistry.getDefault().lookup(ILogWriter.class);
            LogConverterService converterService = (LogConverterService)ServiceRegistry.getDefault().lookup(LogConverterService.class);
            if (log instanceof ProcessQueuedPerResourceLog) {
                logMap = converterService.convert(ProcessStatusPerResourceLog.class, log);
                logMap.put(PROCESS_ID, id);
                writerService.save(logMap);
                continue;
            }
            logMap = converterService.convert(log.getClass(), log);
            logMap.put(PROCESS_ID, id);
            writerService.save(logMap);
        }
        TimeUnit.SECONDS.sleep(20L);
    }

    private Map<String, Integer> getLogCountOnFS(List<ProcessLog> logs) {
        int totalNodeLogsOnFS = 0;
        int totalMessageLogsOnFS = 0;
        int totalResourceLogsOnFS = 0;
        HashMap<String, Integer> processLogTypeCount = new HashMap<String, Integer>();
        for (ProcessLog log : logs) {
            if (log instanceof NodeLog) {
                ++totalNodeLogsOnFS;
                continue;
            }
            if (log instanceof MessageLog) {
                ++totalMessageLogsOnFS;
                continue;
            }
            if (!(log instanceof ProcessStatusPerResourceLog)) continue;
            ++totalResourceLogsOnFS;
        }
        processLogTypeCount.put(NODE_LOG_TYPE, totalNodeLogsOnFS);
        processLogTypeCount.put(MESSAGE_LOG_TYPE, totalMessageLogsOnFS);
        processLogTypeCount.put(RESOURCE_LOG_TYPE, totalResourceLogsOnFS);
        return processLogTypeCount;
    }
}

