/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.nodetype.branch.test;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.graph.ErrorCategory;
import com.tandbergtv.workflow.test.NormalTestBase;
import com.tandbergtv.workflow.test.util.ProcessUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class BranchFail
extends NormalTestBase {
    @Test
    public void testBranchFail() throws Exception {
        WorkflowProcess wp = this.run("branch-fail-template");
        long id = wp.getId();
        BranchFail.assertTrue((boolean)ProcessUtils.sleepUntilStatus(id, 20000L, ProcessStatus.BRANCHED));
        CustomToken root = ProcessUtils.get(id).getRootToken();
        BranchFail.assertEquals((int)root.getChildTokens().size(), (int)3);
        TimeUnit.SECONDS.sleep(10L);
        root = ProcessUtils.get(id).getRootToken();
        wp = ProcessUtils.get(id);
        BranchFail.assertEquals((int)this.failed(root).size(), (int)1);
        BranchFail.assertEquals((int)this.completed(root).size(), (int)2);
        BranchFail.assertEquals((String)this.failed(root).iterator().next().getName().substring(0, 10), (String)"to branch2");
        BranchFail.assertEquals((String)ProcessUtils.getStringVariable(wp, "param1"), (String)"branch 1");
        BranchFail.assertEquals((String)ProcessUtils.getStringVariable(wp, "param2"), (String)"branch 3");
    }

    @Test
    public void testBranchNackFailure() throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        WorkflowProcess wp = this.run("branch-message-nack-template", params);
        BranchFail.assertTrue((boolean)ProcessUtils.sleepUntilStatus(wp.getId(), 60000L, ProcessStatus.BRANCHED));
        Thread.sleep(10000L);
        wp = ProcessUtils.get(wp.getId());
        Collection<CustomToken> collection = this.failed(wp.getRootToken());
        BranchFail.assertTrue((collection.size() > 0 ? 1 : 0) != 0);
        CustomToken failedBranch = collection.iterator().next();
        BranchFail.assertTrue((boolean)failedBranch.getName().contains("to Nack"));
        BranchFail.assertEquals((Object)failedBranch.getErrorDetails().getCategory(), (Object)ErrorCategory.NACK);
    }

    private Collection<CustomToken> failed(CustomToken root) {
        Collection tokens = root.getChildTokens();
        return Collections2.filter((Collection)tokens, (Predicate)new Predicate<CustomToken>(){

            public boolean apply(CustomToken token) {
                return token.getStatus() == ProcessStatus.ERROR;
            }
        });
    }

    private Collection<CustomToken> completed(CustomToken root) {
        Collection tokens = root.getChildTokens();
        return Collections2.filter((Collection)tokens, (Predicate)new Predicate<CustomToken>(){

            public boolean apply(CustomToken token) {
                return token.getStatus() == ProcessStatus.COMPLETED;
            }
        });
    }
}

