/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.rest.services.test;

import com.tandbergtv.workflow.resourcemanager.ResourceManagementException;
import com.tandbergtv.workflow.resourcemanager.ValidationException;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.rest.services.internal.ResourceGroupsResource;
import com.tandbergtv.workflow.rest.services.test.MockRequestType;
import com.tandbergtv.workflow.rest.services.test.RESTServiceMockTestBase;
import com.tandbergtv.workflow.rest.services.test.RESTUtil;
import com.tandbergtv.workflow.test.util.ResourceBuilder;
import com.tandbergtv.workflow.test.util.ResourceUtils;
import com.tandbergtv.workflow.test.util.TestUtil;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.jboss.resteasy.mock.MockHttpResponse;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"normal"})
public class ResourceGroupsGetListTest
extends RESTServiceMockTestBase {
    private static final String BASE_API_PATH = "/resourceGroups";
    private static final String RESOURCEGROUP_FIELD_NAME = "resourceGroups";
    private static final String PARAM_DISPLAY_ALL = "?display=all";
    private static final String PARAM_DETAIL_FULL = "?detail=full";
    private static long resourceGroupId;
    private static final String RESOURCE_GROUP_NAME = "Assert";
    private static final String RESOURCE_TYPE_NAME = "Assert";
    private static final String RESOURCE_TYPE_SYSTEM_ID = "AS";
    private static final String RESOURCE_NAME_PREFIX = "ResourceGroup_";
    private static final int MAX_CONCURRENT_USERS = 5;
    private static final boolean IGNORE_TIMEOUT = false;
    private static List<ResourceGroup> visibleResourceGroups;
    private static List<ResourceGroup> allResourceGroups;
    private List<Resource> resources = new ArrayList<Resource>();

    public ResourceGroupsGetListTest() {
        super(ResourceGroupsResource.class);
    }

    @BeforeClass
    private void setup() throws ResourceManagementException, ValidationException {
        visibleResourceGroups = TestUtil.getResourceManagement().getVisibleResourceGroups();
        allResourceGroups = TestUtil.getResourceManagement().getAllResourceGroups();
        this.sortedResourceGroups();
        ResourceUtils.setResourcesOffline(RESOURCE_TYPE_SYSTEM_ID);
        for (int i = 0; i < 2; ++i) {
            ResourceBuilder builder = ResourceUtils.getResourceBuilderFromSystemId(RESOURCE_TYPE_SYSTEM_ID, RESOURCE_NAME_PREFIX).usesHTTPConnectionString().maxConcurrentUsers(5).ignoreTimeout(false).resourceGroup("Assert");
            Resource tempResource = ResourceUtils.createResource(builder);
            this.resources.add(tempResource);
        }
        for (ResourceGroup group : ResourceUtils.getResourceGroupsByResourceTypeSystemId(RESOURCE_TYPE_SYSTEM_ID)) {
            if (!group.getName().equals("Assert")) continue;
            resourceGroupId = group.getId();
            break;
        }
    }

    @AfterClass
    private void cleanup() throws ResourceManagementException {
        ResourceUtils.deleteResourcesWithPrefix(RESOURCE_TYPE_SYSTEM_ID, RESOURCE_NAME_PREFIX);
        ResourceUtils.setResourcesOnline(RESOURCE_TYPE_SYSTEM_ID);
    }

    public void testVisibleResourceGroups() throws Exception {
        String uri = BASE_API_PATH;
        MockHttpResponse response = this.execute(uri, RESTUtil.setDefaultHeaders(), MockRequestType.GET);
        ResourceGroupsGetListTest.assertEquals((int)response.getStatus(), (int)200);
        Map<String, Object> responseMap = RESTUtil.deserialize(response);
        this.verifyResponse(responseMap, visibleResourceGroups, 0, 10, false, uri, true);
    }

    public void testVisibleResourceGroupsFull() throws Exception {
        String uri = "/resourceGroups?detail=full";
        MockHttpResponse response = this.execute(uri, RESTUtil.setDefaultHeaders(), MockRequestType.GET);
        ResourceGroupsGetListTest.assertEquals((int)response.getStatus(), (int)200);
        Map<String, Object> responseMap = RESTUtil.deserialize(response);
        this.verifyResponse(responseMap, visibleResourceGroups, 0, 10, true, uri, true);
    }

    public void testAllResourceGroups() throws Exception {
        String uri = "/resourceGroups?display=all";
        MockHttpResponse response = this.execute(uri, RESTUtil.setDefaultHeaders(), MockRequestType.GET);
        ResourceGroupsGetListTest.assertEquals((int)response.getStatus(), (int)200);
        Map<String, Object> responseMap = RESTUtil.deserialize(response);
        this.verifyResponse(responseMap, allResourceGroups, 0, 10, false, uri, false);
    }

    public void testResourceGroupGetAllWithStartAndCountParam() throws Exception {
        String uri = "/resourceGroups?display=all&count=3&start=1";
        MockHttpResponse response = this.execute(uri, RESTUtil.setDefaultHeaders(), MockRequestType.GET);
        ResourceGroupsGetListTest.assertEquals((int)response.getStatus(), (int)200);
        Map<String, Object> responseMap = RESTUtil.deserialize(response);
        this.verifyResponse(responseMap, allResourceGroups, 1, 3, false, uri, false);
    }

    public void testResourceGroupGetAllWithInvalidStartParam() throws Exception {
        String uri = "/resourceGroups?display=all&start=-1";
        MockHttpResponse response = this.execute(uri, RESTUtil.setDefaultHeaders(), MockRequestType.GET);
        ResourceGroupsGetListTest.assertEquals((int)response.getStatus(), (int)400);
    }

    public void testResourceGroupGetAllWithInvalidCountParam() throws Exception {
        String uri = "/resourceGroups?count=-1";
        MockHttpResponse response = this.execute(uri, RESTUtil.setDefaultHeaders(), MockRequestType.GET);
        ResourceGroupsGetListTest.assertEquals((int)response.getStatus(), (int)400);
    }

    public void testResourceGroupGetAllWithInvalidDetailParam() throws Exception {
        String uri = "/resourceGroups?detail=" + System.currentTimeMillis();
        MockHttpResponse response = this.execute(uri, RESTUtil.setDefaultHeaders(), MockRequestType.GET);
        ResourceGroupsGetListTest.assertEquals((int)response.getStatus(), (int)400);
    }

    public void testWhenNoVersionHeaderIsSent() throws Exception {
        String uri = BASE_API_PATH;
        MockHttpResponse response = this.execute(uri, new HashMap<String, String>(), MockRequestType.GET);
        ResourceGroupsGetListTest.assertEquals((int)response.getStatus(), (int)412);
    }

    public void testInvalidVersionHeader() throws Exception {
        String uri = BASE_API_PATH;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-API-Version", "2");
        MockHttpResponse response = this.execute(uri, headers, MockRequestType.GET);
        ResourceGroupsGetListTest.assertEquals((int)response.getStatus(), (int)412);
    }

    public void getResourcesByResourceGroupId() throws URISyntaxException, JsonParseException, JsonMappingException, IOException {
        String uri = "/resourceGroups/" + resourceGroupId + "/resources?detail=full";
        Map<String, Object> responseMap = this.getResponseMap(uri);
        ResourceGroupsGetListTest.assertEquals((String)responseMap.get("total").toString(), (String)"3");
        ResourceGroupsGetListTest.assertEquals((String)responseMap.get("start").toString(), (String)"0");
        ResourceGroupsGetListTest.assertEquals((String)responseMap.get("count").toString(), (String)"10");
        List resourceList = (List)responseMap.get("resources");
        for (Map resource : resourceList) {
            if (!resource.get("name").toString().contains(RESOURCE_NAME_PREFIX)) continue;
            ResourceGroupsGetListTest.assertTrue((boolean)resource.get("resourceTypeName").toString().contains("Assert"));
            ResourceGroupsGetListTest.assertTrue((boolean)resource.get("connectionString").toString().contains(RESOURCE_NAME_PREFIX));
            ResourceGroupsGetListTest.assertEquals((String)resource.get("maxConcurrentUsage").toString(), (String)String.valueOf(5));
            ResourceGroupsGetListTest.assertEquals((String)resource.get("ignoreTimeOut").toString(), (String)String.valueOf(false));
            ResourceGroupsGetListTest.assertTrue((boolean)resource.get(RESOURCEGROUP_FIELD_NAME).toString().contains("Assert"));
        }
    }

    public void getResourcesByResourceGroupName() throws URISyntaxException, JsonParseException, JsonMappingException, IOException {
        String uri = "/resourceGroups/name/Assert/resources?detail=full";
        Map<String, Object> responseMap = this.getResponseMap(uri);
        ResourceGroupsGetListTest.assertEquals((String)responseMap.get("total").toString(), (String)"3");
    }

    private void verifyResponse(Map<String, Object> responseMap, List<ResourceGroup> expected, int start, int count, boolean isFull, String uri, boolean isVisible) throws JsonParseException, JsonMappingException, IOException, ResourceManagementException {
        this.verifyPagingParametersInResponse(responseMap, start, count, uri, isVisible);
        this.verifyResourceGroupsList(responseMap, expected, start, count, isFull);
    }

    private void verifyPagingParametersInResponse(Map<String, Object> responseMap, int start, int count, String uri, boolean isVisible) throws JsonParseException, JsonMappingException, IOException {
        int total = Integer.valueOf(responseMap.get("total").toString());
        if (isVisible) {
            ResourceGroupsGetListTest.assertEquals((int)total, (int)visibleResourceGroups.size());
        } else {
            ResourceGroupsGetListTest.assertEquals((int)total, (int)allResourceGroups.size());
        }
        ResourceGroupsGetListTest.assertEquals((Object)responseMap.get("start"), (Object)start);
        ResourceGroupsGetListTest.assertEquals((Object)responseMap.get("count"), (Object)count);
        if (total > start + count) {
            ResourceGroupsGetListTest.assertEquals((Object)responseMap.get("next"), (Object)("http://localhost:8081" + RESTUtil.getExpectedUrl(uri, start, start + count)));
        } else {
            ResourceGroupsGetListTest.assertFalse((boolean)responseMap.containsKey("next"));
        }
        if (start > 0) {
            if (start - count < 0) {
                ResourceGroupsGetListTest.assertEquals((Object)responseMap.get("prev"), (Object)("http://localhost:8081" + RESTUtil.getExpectedUrl(uri, start, 0)));
            } else {
                ResourceGroupsGetListTest.assertEquals((Object)responseMap.get("prev"), (Object)("http://localhost:8081" + RESTUtil.getExpectedUrl(uri, start, start - count)));
            }
            ResourceGroupsGetListTest.assertEquals((Object)responseMap.get("first"), (Object)("http://localhost:8081" + RESTUtil.getExpectedUrl(uri, start, 0)));
        } else {
            ResourceGroupsGetListTest.assertFalse((boolean)responseMap.containsKey("prev"));
            ResourceGroupsGetListTest.assertFalse((boolean)responseMap.containsKey("first"));
        }
    }

    private void verifyResourceGroupsList(Map<String, Object> responseMap, List<ResourceGroup> expected, int start, int count, boolean isFull) {
        List actual = (List)responseMap.get(RESOURCEGROUP_FIELD_NAME);
        int endIndex = Math.min(expected.size(), start + count);
        List<Object> resourceGroups = start < endIndex ? expected.subList(start, endIndex) : Collections.emptyList();
        ResourceGroupsGetListTest.assertEquals((int)resourceGroups.size(), (int)actual.size());
        int i = 0;
        for (ResourceGroup resourceGroup : resourceGroups) {
            this.verifyResponseParametersFull((Map)actual.get(i), resourceGroup, isFull);
            ++i;
        }
    }

    private void verifyListParameters(Map<String, Object> actual, ResourceGroup expected) {
        ResourceGroupsGetListTest.assertEquals((String)actual.get("id").toString(), (String)String.valueOf(expected.getId()));
        ResourceGroupsGetListTest.assertEquals((String)actual.get("name").toString(), (String)expected.getName());
        ResourceGroupsGetListTest.assertEquals((Object)actual.get("href"), (Object)("http://localhost:8081/resourceGroups/" + String.valueOf(expected.getId())));
        ResourceGroupsGetListTest.assertTrue((boolean)(actual.get("queueSize") instanceof Integer));
    }

    private void verifyResponseParametersFull(Map<String, Object> actual, ResourceGroup expected, boolean isFull) {
        this.verifyListParameters(actual, expected);
        if (isFull) {
            ResourceGroupsGetListTest.assertEquals((String)actual.get("isInternallyAcquired").toString(), (String)String.valueOf(expected.isInternallyAcquired()));
            ResourceGroupsGetListTest.assertEquals((String)actual.get("isVisible").toString(), (String)String.valueOf(expected.isVisible()));
            ResourceGroupsGetListTest.assertEquals((String)actual.get("resourceTypeName").toString(), (String)expected.getResourceType().getName());
        }
    }

    private void sortedResourceGroups() {
        Collections.sort(visibleResourceGroups, this.defaultComparator());
        Collections.sort(allResourceGroups, this.defaultComparator());
    }

    private Comparator<ResourceGroup> defaultComparator() {
        return new Comparator<ResourceGroup>(){

            @Override
            public int compare(ResourceGroup t1, ResourceGroup t2) {
                return t1.getName().toLowerCase().compareTo(t2.getName().toLowerCase());
            }
        };
    }
}

