/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.process.test;

import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.DriverException;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import com.tandbergtv.workflow.driver.template.ITemplateReader;
import com.tandbergtv.workflow.driver.template.ITemplateService;
import com.tandbergtv.workflow.driver.template.watch.FileReader;
import com.tandbergtv.workflow.driver.template.watch.PackagedFileReader;
import java.io.File;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"normal"})
public class TemplateTest {
    private Long idToBeDeleted;
    private Logger logger = Logger.getLogger(TemplateTest.class);

    @Test
    void service() {
        Assert.assertNotNull((Object)this.getService(ITemplateService.class));
    }

    private ITemplateService getTemplateService() {
        return this.getService(ITemplateService.class);
    }

    private ITemplateLoaderService getTemplateLoaderService() {
        return this.getService(ITemplateLoaderService.class);
    }

    private <T> T getService(Class<T> clazz) {
        return (T)ServiceRegistry.getDefault().lookup(clazz);
    }

    @Test(dependsOnMethods={"service"})
    void testPAR() throws Exception {
        this.createPar(new File("resources/Echo.par"));
        Thread.sleep(60000L);
        WorkflowTemplate newTemplate = this.getTemplateService().getTemplateByName("Echo");
        Assert.assertNotNull((Object)newTemplate);
        this.idToBeDeleted = newTemplate.getId();
    }

    private void createPar(File par) throws InterruptedException {
        this.getTemplateLoaderService().runCompiler(par, (ITemplateReader)new PackagedFileReader(par));
        Thread.sleep(TimeUnit.SECONDS.toMillis(10L));
    }

    @Test(dependsOnMethods={"testPAR"})
    void testVersionForPar() {
        Assert.assertEquals((int)29, (int)this.getTemplateService().getTemplateByName("Echo").getVersion());
    }

    @Test(dependsOnMethods={"service"})
    void testXml() throws Exception {
        this.createXml(new File("resources/processdefinition.xml"));
        Thread.sleep(60000L);
        Assert.assertNotNull((Object)this.getTemplateService().getTemplateByName("Echo2"));
    }

    private void createXml(File xml) throws InterruptedException {
        this.getTemplateLoaderService().runCompiler(xml, (ITemplateReader)new FileReader(xml));
        Thread.sleep(TimeUnit.SECONDS.toMillis(10L));
    }

    @Test(dependsOnMethods={"testXml"})
    void testVersionForXml() {
        Assert.assertEquals((int)21, (int)this.getTemplateService().getTemplateByName("Echo2").getVersion());
    }

    private void setId(WorkflowTemplate template, Long id) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        template.setId(id.longValue());
    }

    void testGetAllTemplateNames() {
        List names = this.getTemplateService().getAllActivatedTemplateNames();
        Assert.assertEquals((boolean)names.contains("Asset Ingest - v48"), (boolean)true);
    }

    void testGetTemplate() throws DriverException {
        WorkflowTemplate template = this.getTemplateService().getTemplateById(3L);
        Assert.assertEquals((String)template.getName(), (String)"Asset Ingest");
    }

    void testGetTemplateByFullName() {
        Assert.assertNotNull((Object)this.getTemplateService().getTemplateByFullName("Asset Ingest - v48"));
    }

    void testGetTemplateByName() {
        Assert.assertNotNull((Object)this.getTemplateService().getTemplateByName("Asset Ingest"));
    }

    @Test(dependsOnMethods={"testDeletionOfOldTemplates"})
    void testDelete() throws Exception {
        WorkflowTemplate template = this.getTemplateService().getTemplateById(this.idToBeDeleted.longValue());
        Assert.assertNotNull((Object)template);
        this.getTemplateService().deactivate(this.idToBeDeleted.longValue());
        Assert.assertNull((Object)this.getTemplateService().getTemplateByFullName(template.getFullName()));
    }

    @Test(dependsOnMethods={"testVersionForPar"})
    void testDeletionOfOldTemplates() throws Exception {
        WorkflowTemplate template = this.getTemplateService().getTemplateByName("Echo");
        Assert.assertNotNull((Object)template);
        Assert.assertTrue((boolean)this.getTemplateService().getPreviousVersions(template).isEmpty());
    }

    @Test(dependsOnMethods={"service"})
    void testAddSelector() throws Exception {
        String selectionKey = "020102";
        WorkflowTemplate template = this.getTemplateService().getTemplateById(3L);
        this.getTemplateService().addSelectorKey(selectionKey, template.getName());
        Assert.assertEquals((String)template.getName(), (String)this.getTemplateService().getTemplateBySelectorKey(selectionKey).getName());
    }

    @Test(dependsOnMethods={"testAddSelector"})
    void testRemoveSelector() {
        String selectionKey = "020102";
        WorkflowTemplate template = this.getTemplateService().getTemplateById(3L);
        this.getTemplateService().removeSelectorKey(selectionKey, template.getName());
        Assert.assertNull((Object)this.getTemplateService().getTemplateBySelectorKey(selectionKey));
    }
}

