/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.process.test;

import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.test.SequentialTestBase;
import com.tandbergtv.workflow.test.util.ProcessUtils;
import com.tandbergtv.workflow.test.util.ResourceUtils;
import java.util.HashMap;
import org.testng.annotations.Test;

public class ChangeOperationalStatus
extends SequentialTestBase {
    @Test
    public void testInProcess() throws Exception {
        WorkflowProcess wp = this.run("subprocess-children-template", new HashMap<String, Object>());
        long id = wp.getId();
        this.ensureProcessReachesStatus(id, 10000L, ProcessStatus.BUSY);
        wp = ProcessUtils.get(id);
        this.verifyAllowedActions(wp, new boolean[]{true, false, true, false, false, false});
    }

    @Test
    public void testCompleted() throws Exception {
        WorkflowProcess wp = this.run("subprocess-children-template", new HashMap<String, Object>());
        long id = wp.getId();
        this.ensureProcessReachesStatus(id, 120000L, ProcessStatus.COMPLETED);
        wp = ProcessUtils.get(id);
        this.verifyAllowedActions(wp, new boolean[]{false, true, false, true, false, false});
    }

    @Test
    public void testFailed() throws Exception {
        WorkflowProcess wp = this.run("FailureTemplate", new HashMap<String, Object>());
        long id = wp.getId();
        this.ensureProcessReachesStatus(id, 10000L, ProcessStatus.ERROR);
        wp = ProcessUtils.get(id);
        this.verifyAllowedActions(wp, new boolean[]{true, true, false, true, false, true});
    }

    @Test
    public void testCancelled() throws Exception {
        WorkflowProcess wp = this.run("FailureTemplate", new HashMap<String, Object>());
        long id = wp.getId();
        this.ensureProcessReachesStatus(id, 10000L, ProcessStatus.ERROR);
        wp = ProcessUtils.get(id);
        wp.getRootToken().cancel();
        this.ensureProcessReachesStatus(id, 10000L, ProcessStatus.CANCELLED);
        wp = ProcessUtils.get(id);
        this.verifyAllowedActions(wp, new boolean[]{false, true, false, true, false, false});
    }

    @Test
    public void testQueued() throws Exception {
        ResourceUtils.setResourcesOffline("27");
        WorkflowProcess wp = this.run("subprocess-children-template", new HashMap<String, Object>());
        long id = wp.getId();
        this.ensureProcessReachesStatus(id, 15000L, ProcessStatus.QUEUED);
        wp = ProcessUtils.get(id);
        this.verifyAllowedActions(wp, new boolean[]{true, false, true, false, false, false});
        ResourceUtils.setResourcesOnline("27");
    }

    @Test
    public void testPaused() throws Exception {
        WorkflowProcess wp = this.run("subprocess-children-template", new HashMap<String, Object>());
        long id = wp.getId();
        this.ensureProcessReachesStatus(id, 10000L, ProcessStatus.BUSY);
        wp = ProcessUtils.get(id);
        wp.suspend();
        this.ensureProcessReachesStatus(id, 10000L, ProcessStatus.PAUSED);
        wp = ProcessUtils.get(id);
        this.verifyAllowedActions(wp, new boolean[]{true, false, false, false, true, false});
    }

    @Test(enabled=false)
    public void testBranched() throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("errorCode", 1);
        WorkflowProcess wp = this.run("combo-1-template", params);
        long id = wp.getId();
        this.ensureProcessReachesStatus(id, 10000L, ProcessStatus.BRANCHED);
        Thread.sleep(5000L);
        wp = ProcessUtils.get(id);
        this.verifyAllowedActions(wp, new boolean[]{true, false, true, false, false, true});
    }

    private void verifyAllowedActions(WorkflowProcess wp, boolean[] isAllowedList) {
        ChangeOperationalStatus.assertEquals((boolean)wp.getCanBeCancelled(), (boolean)isAllowedList[0]);
        ChangeOperationalStatus.assertEquals((boolean)wp.getCanBeDeleted(), (boolean)isAllowedList[1]);
        ChangeOperationalStatus.assertEquals((boolean)wp.getCanBePaused(), (boolean)isAllowedList[2]);
        ChangeOperationalStatus.assertEquals((boolean)wp.getCanBeRestarted(), (boolean)isAllowedList[3]);
        ChangeOperationalStatus.assertEquals((boolean)wp.getCanBeResumed(), (boolean)isAllowedList[4]);
        ChangeOperationalStatus.assertEquals((boolean)wp.getCanBeRetried(), (boolean)isAllowedList[5]);
    }

    private void ensureProcessReachesStatus(long processId, long timeout, ProcessStatus status) throws Exception {
        ChangeOperationalStatus.assertTrue((boolean)ProcessUtils.sleepUntilStatus(processId, timeout, status), (String)("Process " + processId + " did not reach status " + status + " within " + timeout + " milliseconds"));
    }
}

