/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.internal;

import com.tandbergtv.workflow.adaptor.IAdaptor;
import com.tandbergtv.workflow.adaptor.IAdaptorRequest;
import com.tandbergtv.workflow.adaptor.IAdaptorResponse;
import com.tandbergtv.workflow.adaptor.IAdaptorService;
import com.tandbergtv.workflow.adaptor.conf.AdaptorConfigurationException;
import com.tandbergtv.workflow.adaptor.conf.IAdaptorConfiguration;
import com.tandbergtv.workflow.adaptor.conf.IMessageProcessorConfiguration;
import com.tandbergtv.workflow.adaptor.dispatcher.DispatcherException;
import com.tandbergtv.workflow.adaptor.dispatcher.IDispatcher;
import com.tandbergtv.workflow.adaptor.handler.HandlerException;
import com.tandbergtv.workflow.adaptor.handler.IHandler;
import com.tandbergtv.workflow.adaptor.internal.AbstractDefaultAdaptor;
import com.tandbergtv.workflow.adaptor.internal.AdaptorResponseFactory;
import com.tandbergtv.workflow.adaptor.internal.DefaultAdaptorContext;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.comm.internal.DeviceFactory;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.registry.IMessageRegistry;
import java.net.MalformedURLException;
import java.util.List;
import org.apache.log4j.Logger;

public class DefaultAdaptor
extends AbstractDefaultAdaptor
implements IAdaptor {
    private static final Logger LOGGER = Logger.getLogger(DefaultAdaptor.class);
    private ServiceRegistry services = ServiceRegistry.getDefault();
    private DefaultAdaptorContext context;
    private final String systemDeviceId;

    public DefaultAdaptor(String systemDeviceId) {
        this.systemDeviceId = systemDeviceId;
        this.context = new DefaultAdaptorContext();
    }

    public void init(IAdaptorConfiguration conf) {
        LOGGER.debug((Object)("Adaptor " + this.systemDeviceId + " initializing..."));
    }

    public void destroy() {
        this.context.destroy();
        LOGGER.debug((Object)("Adaptor " + this.systemDeviceId + " destroyed"));
    }

    @Override
    protected List<IDestination> getDestinations(IAdaptorRequest request, IMessageUID uid) {
        List destinations = request.getDestinations();
        if (destinations.isEmpty()) {
            destinations.addAll(this.loadDestinations(uid));
        }
        if (destinations.isEmpty()) {
            destinations.add(this.getDefaultDestination());
        }
        return destinations;
    }

    @Override
    protected IMessageProcessorConfiguration getConfiguration(IMessageUID uid) {
        IMessageProcessorConfiguration conf = this.context.getConfiguration(uid);
        if (conf == null) {
            throw new AdaptorConfigurationException("The configuration for uid " + uid + " could not be found.");
        }
        return conf;
    }

    @Override
    public void addConfiguration(IMessageUID uid, IMessageProcessorConfiguration conf) {
        this.context.addConfiguration(uid, conf);
    }

    @Override
    protected IHandler getHandler(IMessageProcessorConfiguration conf) throws HandlerException {
        return this.context.getHandler(conf);
    }

    @Override
    protected IDispatcher getDispatcher(IMessageProcessorConfiguration conf, IDestination dst) throws DispatcherException {
        return this.context.getDispatcher(conf, dst);
    }

    @Override
    protected IAdaptorResponse createDefaultResponse(IAdaptorRequest request) {
        return AdaptorResponseFactory.newInstance().createDefaultResponse(request);
    }

    private List<IDestination> loadDestinations(IMessageUID uid) {
        List<IDestination> destinations = this.context.getDestinations(uid);
        LOGGER.debug((Object)("Sending to " + destinations.size() + " destination(s)"));
        return destinations;
    }

    private IDestination getDefaultDestination() {
        IDestination destination = null;
        try {
            DeviceFactory factory = DeviceFactory.newInstance();
            destination = (IDestination)factory.createDevice("http://0.0.0.0", "default");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return destination;
    }

    public boolean canDeliver(IAdaptorRequest request) {
        try {
            if (request == null || request.getMessage() == null) {
                return false;
            }
            IMessageUID uid = this.getMessageUID(request.getMessage());
            if (uid == null) {
                return false;
            }
            IMessageRegistry registry = ((IAdaptorService)this.services.lookup(IAdaptorService.class)).getMessageRegistry();
            String deviceId = registry.getMessageDeviceID(uid.getUID());
            return deviceId != null && deviceId.equals(this.systemDeviceId);
        }
        catch (Exception e) {
            String msg = "Failure when determining if adaptor[" + this.systemDeviceId + "] can deliver message";
            LOGGER.debug((Object)msg, (Throwable)e);
            return false;
        }
    }
}

