/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.internal;

import com.tandbergtv.workflow.adaptor.AdaptorException;
import com.tandbergtv.workflow.adaptor.IAdaptorService;
import com.tandbergtv.workflow.adaptor.registration.AdaptorRegistrationFactory;
import com.tandbergtv.workflow.adaptor.registration.IAdaptorRegistration;
import com.tandbergtv.workflow.adaptor.registry.IAdaptorRegistry;
import com.tandbergtv.workflow.adaptor.registry.impl.AdaptorRegistryImpl;
import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.IMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceEvent;
import com.tandbergtv.workflow.core.service.ServiceEvents;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.message.registry.IMessageRegistry;
import com.tandbergtv.workflow.message.registry.MessageRegistry;
import com.tandbergtv.workflow.pluginmanager.PluginManagement;
import com.tandbergtv.workflow.pluginmanager.entities.ResourceTypeDescriptor;
import com.tandbergtv.workflow.pluginmanager.event.ResourceTypeDescriptorChangeEvent;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class AdaptorService
implements IAdaptorService,
IColleague {
    private IAdaptorRegistry registry;
    private IMessageRegistry messages = new MessageRegistry();
    private String retryInterval;
    private String retryCount;
    private static final Logger LOGGER = Logger.getLogger(AdaptorService.class);
    private static final String SERVICE_NAME = "Adaptor Service";
    private static final String SCHEDULER_NAME = "adaptor-events";
    private ISchedulerService<Void> eventScheduler;

    public AdaptorService(String retryInterval, String retryCount) {
        this.registry = new AdaptorRegistryImpl(this.messages);
        this.retryCount = retryCount;
        this.retryInterval = retryInterval;
    }

    @Override
    public IAdaptorRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public IMessageRegistry getMessageRegistry() {
        return this.messages;
    }

    public String getColleagueName() {
        return this.getServiceName();
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.NORMAL;
    }

    public void receive(WorkflowEvent event) {
        if (event instanceof ResourceTypeDescriptorChangeEvent) {
            this.eventScheduler.schedule((Callable)new EventHandlerCallable(event));
        }
    }

    public void start() {
        IMediator mediator = DefaultMediator.getInstance();
        mediator.sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STARTING));
        LOGGER.debug((Object)"loading plugins...");
        PluginManagement manager = (PluginManagement)ServiceRegistry.getDefault().lookup(PluginManagement.class);
        AdaptorRegistrationFactory factory = AdaptorRegistrationFactory.newInstance();
        IAdaptorRegistration registration = factory.newAdaptorRegistration();
        ArrayList allDescriptors = new ArrayList();
        allDescriptors.addAll(manager.getResourceTypeDescriptors());
        allDescriptors.addAll(manager.getNonLicensedDescriptors());
        for (ResourceTypeDescriptor descriptor : allDescriptors) {
            descriptor.setRetryInterval(this.retryInterval);
            descriptor.setRetryCount(this.retryCount);
            this.registerAdaptor(registration, descriptor);
        }
        this.eventScheduler = new Scheduler(SCHEDULER_NAME, 1, 1);
        this.eventScheduler.start();
        mediator.register((IColleague)this);
        mediator.sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STARTED));
    }

    public void stop() {
        IMediator mediator = DefaultMediator.getInstance();
        mediator.sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STOPPING));
        mediator.unregister((IColleague)this);
        this.eventScheduler.stop();
        this.eventScheduler = null;
        this.registry.clear();
        this.messages.clear();
        mediator.sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STOPPED));
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    private void handleResourceTypeDescriptorChangeEvent(ResourceTypeDescriptorChangeEvent event) {
        AdaptorRegistrationFactory factory = AdaptorRegistrationFactory.newInstance();
        IAdaptorRegistration registration = factory.newAdaptorRegistration();
        ResourceTypeDescriptor descriptor = event.getDescriptor();
        this.registerAdaptor(registration, descriptor);
    }

    private void registerAdaptor(IAdaptorRegistration registration, ResourceTypeDescriptor descriptor) {
        try {
            registration.registerAdaptor(descriptor);
        }
        catch (AdaptorException e) {
            LOGGER.error((Object)("Failed to register adaptor for resource type plugin[" + descriptor + "]"));
        }
    }

    private class EventHandlerCallable
    implements Callable<Void> {
        private final WorkflowEvent event;

        public EventHandlerCallable(WorkflowEvent event) {
            this.event = event;
        }

        @Override
        public Void call() throws Exception {
            try {
                if (this.event instanceof ResourceTypeDescriptorChangeEvent) {
                    AdaptorService.this.handleResourceTypeDescriptorChangeEvent((ResourceTypeDescriptorChangeEvent)this.event);
                }
            }
            catch (RuntimeException e) {
                LOGGER.error((Object)("failure handling event[" + this.event.getClass().getName() + "]"), (Throwable)e);
            }
            return null;
        }
    }
}

