/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.monitor;

import com.hazelcast.config.Config;
import com.hazelcast.config.FileSystemXmlConfig;
import com.hazelcast.config.TcpIpConfig;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class ClusterConfiguration {
    private static final String DEFAULT_TCP_PORT = "5712";
    private static final String HAZELCAST_PORT = "host.port";
    private static final String HAZELCAST_XML_CONFIG_PATH = "xml.config.path";
    private static final String HAZELCAST_DISCOVERY_TYPE = "discovery.type";
    private static final String HAZELCAST_MULTICAST_GROUP = "multicast.ip";
    private static final String HAZELCAST_MULTICAST_PORT = "multicast.port";
    private static final String HAZELCAST_TCPIP_HOSTS = "tcpip.hosts";
    private static final String HAZELCAST_HOST_IP = "host.ip";
    private static final String HAZELCAST_HOST_INTERFACE = "host.interface";
    private static final String HAZELCAST_CLUSTER_NAME = "cluster.name";
    private static final String HAZELCAST_CLUSTER_PASSWORD = "cluster.password";
    private static final String HAZELCAST_INITIAL_WAIT = "initial.wait";
    private static final Logger LOGGER = Logger.getLogger(ClusterConfiguration.class);

    private ClusterConfiguration() {
    }

    public static Config create(Properties properties) throws IOException {
        System.setProperty("hazelcast.logging.type", "log4j");
        String xmlPath = properties.getProperty(HAZELCAST_XML_CONFIG_PATH);
        if (xmlPath != null) {
            FileSystemXmlConfig cfg = new FileSystemXmlConfig(xmlPath);
            return cfg;
        }
        Config config = new Config();
        config.setPort(Integer.parseInt(properties.getProperty(HAZELCAST_PORT, DEFAULT_TCP_PORT)));
        ClusterConfiguration.configureClusterDiscovery(config, properties);
        ClusterConfiguration.configureClusterHost(config, properties);
        ClusterConfiguration.configureClusterName(config, properties);
        ClusterConfiguration.configureInitialWait(config, properties);
        return config;
    }

    private static void configureInitialWait(Config config, Properties properties) throws IOException {
        String wait = properties.getProperty(HAZELCAST_INITIAL_WAIT);
        if (wait != null) {
            config.setProperty("hazelcast.initial.wait.seconds", wait);
        }
    }

    private static void configureClusterName(Config config, Properties properties) throws IOException {
        String password;
        String name = properties.getProperty(HAZELCAST_CLUSTER_NAME);
        if (name != null) {
            LOGGER.debug((Object)("Cluster name " + name));
            config.getGroupConfig().setName(name);
        }
        if ((password = properties.getProperty(HAZELCAST_CLUSTER_PASSWORD)) != null) {
            config.getGroupConfig().setPassword(password);
        }
    }

    private static void configureClusterHost(Config config, Properties properties) throws IOException {
        config.getNetworkConfig().getInterfaces().clear();
        String host = properties.getProperty(HAZELCAST_HOST_IP);
        if (host == null || "".equals(host.trim())) {
            LOGGER.warn((Object)"Host IP address not provided");
            String netInterface = properties.getProperty(HAZELCAST_HOST_INTERFACE);
            String hostip = "";
            if (netInterface != null && !"".equals(netInterface.trim())) {
                hostip = ClusterConfiguration.getAddressByInterface(netInterface).getHostAddress();
            } else {
                hostip = ClusterConfiguration.getAddress().getHostAddress();
                LOGGER.warn((Object)"Setting default host");
            }
            config.getNetworkConfig().getInterfaces().addInterface(hostip);
            LOGGER.debug((Object)("Cluster host " + hostip));
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(host, ",;");
            while (stringTokenizer.hasMoreTokens()) {
                String token = stringTokenizer.nextToken().trim();
                if ("".equals(token)) continue;
                config.getNetworkConfig().getInterfaces().addInterface(token);
            }
            LOGGER.debug((Object)("Cluster host " + host));
        }
        config.getNetworkConfig().getInterfaces().setEnabled(true);
    }

    private static void configureClusterDiscovery(Config config, Properties properties) {
        String discoveryType = properties.getProperty(HAZELCAST_DISCOVERY_TYPE);
        LOGGER.debug((Object)("Hazelcast discovery type: " + discoveryType));
        if ("tcpip".equalsIgnoreCase(discoveryType)) {
            ClusterConfiguration.configureTcpIpDiscovery(config, properties);
        } else {
            ClusterConfiguration.configureMulticastDiscovery(config, properties);
        }
    }

    private static void configureMulticastDiscovery(Config config, Properties properties) {
        String port;
        LOGGER.debug((Object)"Configuring multicast cluster discovery.");
        config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(true);
        config.getNetworkConfig().getJoin().getTcpIpConfig().setEnabled(false);
        String ip = properties.getProperty(HAZELCAST_MULTICAST_GROUP);
        if (ip != null) {
            config.getNetworkConfig().getJoin().getMulticastConfig().setMulticastGroup(ip);
            LOGGER.debug((Object)("Cluster multicast group: " + ip));
        }
        if ((port = properties.getProperty(HAZELCAST_MULTICAST_PORT)) != null) {
            config.getNetworkConfig().getJoin().getMulticastConfig().setMulticastPort(Integer.parseInt(port));
            LOGGER.debug((Object)("Cluster multicast port: " + port));
        }
    }

    private static void configureTcpIpDiscovery(Config config, Properties properties) {
        LOGGER.debug((Object)"Configuring TCP/IP cluster discovery.");
        config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
        config.getNetworkConfig().getJoin().getTcpIpConfig().setEnabled(true);
        TcpIpConfig tcpip = config.getNetworkConfig().getJoin().getTcpIpConfig();
        String hosts = properties.getProperty(HAZELCAST_TCPIP_HOSTS);
        if (hosts != null) {
            StringTokenizer tkz = new StringTokenizer(hosts, ",; ");
            while (tkz.hasMoreTokens()) {
                String host = tkz.nextToken().trim();
                try {
                    if ("".equals(host)) continue;
                    LOGGER.debug((Object)("Adding host: " + host));
                    tcpip.addMember(host);
                }
                catch (Exception ex) {
                    LOGGER.error((Object)("Could not add host: " + host), (Throwable)ex);
                }
            }
        }
    }

    private static InetAddress getAddress() throws IOException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface ni = interfaces.nextElement();
            Enumeration<InetAddress> addresses = ni.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (!(address instanceof Inet4Address) || address.isLoopbackAddress()) continue;
                return address;
            }
        }
        return InetAddress.getLocalHost();
    }

    private static InetAddress getAddressByInterface(String iname) throws IOException {
        NetworkInterface netInterface = NetworkInterface.getByName(iname);
        Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
        while (addresses.hasMoreElements()) {
            InetAddress address = addresses.nextElement();
            if (!(address instanceof Inet4Address) || address.isLoopbackAddress()) continue;
            LOGGER.info((Object)("getAddressByInterface(" + iname + ") " + address));
            return address;
        }
        return InetAddress.getLocalHost();
    }
}

