/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.util;

import com.tandbergtv.workflow.util.HostnameResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class URLConfigReader {
    private static final Logger LOGGER = Logger.getLogger(URLConfigReader.class);
    private static final String APP_HOST_NAME_XPATH = "/urlconfig/@applicationHostName";
    private static final String URL_XPATH = "/urlconfig/url";
    private static final String DEFAULT_PROTOCOL = "http";

    URLConfigReader() {
    }

    public static Map<String, String> read(File file) throws IOException {
        HashMap<String, String> urlMap = new HashMap<String, String>();
        Document configDocument = URLConfigReader.loadDocument(file);
        URLConfigReader.loadURLs(urlMap, configDocument);
        return urlMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document loadDocument(File file) {
        Document document = null;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(file);
                document = builder.parse(stream);
            }
            finally {
                if (stream != null) {
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (Exception e) {
                        LOGGER.warn((Object)("Failed to close the input stream for file: " + file.getAbsolutePath()));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load url configuration file: " + file.getAbsolutePath() + " into an XML document.", e);
        }
        return document;
    }

    private static void loadURLs(Map<String, String> urlMap, Document document) throws IOException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            String hostName = HostnameResolver.resolveLocalName(xpath.evaluate(APP_HOST_NAME_XPATH, document));
            NodeList nodes = (NodeList)xpath.evaluate(URL_XPATH, document, XPathConstants.NODESET);
            for (int index = 0; index < nodes.getLength(); ++index) {
                String portValue;
                String host;
                Node node = nodes.item(index);
                String name = xpath.evaluate("name", node);
                String protocol = xpath.evaluate("protocol", node);
                if (URLConfigReader.isValueBlank(protocol)) {
                    protocol = DEFAULT_PROTOCOL;
                }
                if (URLConfigReader.isValueBlank(host = xpath.evaluate("host", node))) {
                    host = hostName;
                }
                int port = URLConfigReader.isValueBlank(portValue = xpath.evaluate("port", node)) ? -1 : Integer.parseInt(portValue.trim());
                String filePath = xpath.evaluate("relativePath", node);
                String url = new URL(protocol, host, port, filePath).toExternalForm();
                String updatedUrl = HostnameResolver.replaceURLWithIP(url);
                urlMap.put(name, updatedUrl);
                LOGGER.debug((Object)("IP for " + name + " is " + updatedUrl));
            }
        }
        catch (XPathException e) {
            throw new RuntimeException("Failed to parse URL configuration XML document", e);
        }
    }

    private static boolean isValueBlank(String value) {
        return value == null || value.trim().length() == 0;
    }
}

