/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.settings;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.settings.ISettingsProvider;
import com.tandbergtv.workflow.core.settings.SettingsPluginLoader;
import com.tandbergtv.workflow.driver.boot.ILicenseProvider;
import com.tandbergtv.workflow.settings.ISettingUpdateListenter;
import com.tandbergtv.workflow.settings.SettingParser;
import com.tandbergtv.workflow.web.util.LicenseProviderFactory;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class RemoteSettingsUpdateNotificationService
implements Service {
    public static final String WF_LICENSE_SETTING = "WF_LICENSE_SETTING";
    private static final Logger LOGGER = Logger.getLogger(RemoteSettingsUpdateNotificationService.class);
    private static final long DEFAULT_DELAY = 5L;
    private static final long DEFAULT_REFRESH_INTERVAL = 300L;
    private ScheduledExecutorService scheduledExecutorService;
    private volatile ISettingsProvider settingsProvider;
    private long delay = 5L;
    private long interval = 300L;
    private List<ISettingUpdateListenter> updateListeners = Lists.newArrayList();
    private Set<String> listenerPaths = Sets.newLinkedHashSet();
    private Map<String, String> settingCache = Maps.newConcurrentMap();

    public RemoteSettingsUpdateNotificationService() {
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
    }

    protected Map<String, String> getSetting(String path) {
        return new SettingParser().getSetting(this.settingCache, path);
    }

    public void start() {
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                RemoteSettingsUpdateNotificationService.this.handleNeptuneSetting();
                RemoteSettingsUpdateNotificationService.this.handleLicenseSetting();
            }
        }, this.delay, this.interval, TimeUnit.SECONDS);
    }

    private void handleNeptuneSetting() {
        if (this.getSettingsProvider() == null) {
            LOGGER.warn((Object)"NeptuneSettingsProvider is not properly setup, cannot get settings");
            return;
        }
        for (String path : this.getNeptuneSettingFetchPath()) {
            try {
                String oldValue = this.settingCache.get(path);
                String newValue = this.getSettingsProvider().getPropertiesAsJSON(path);
                if (oldValue != null && StringUtils.equals((String)oldValue, (String)newValue)) continue;
                this.settingCache.put(path, newValue);
                LOGGER.info((Object)("setting[" + path + "] updated with value[" + newValue + "]"));
                this.notifyChanged(path);
            }
            catch (Exception e) {
                LOGGER.warn((Object)("refreshing Neptune setting[" + path + "] fail"), (Throwable)e);
            }
        }
    }

    private Set<String> getNeptuneSettingFetchPath() {
        LinkedHashSet paths = Sets.newLinkedHashSet(this.listenerPaths);
        paths.remove(WF_LICENSE_SETTING);
        return paths;
    }

    private void handleLicenseSetting() {
        ILicenseProvider provider = LicenseProviderFactory.getLicenseProvider();
        if (provider == null) {
            LOGGER.warn((Object)"ILicenseProvider is not properly setup, cannot get settings");
            return;
        }
        try {
            Properties properties = provider.getProperties();
            String oldValue = this.settingCache.get(WF_LICENSE_SETTING);
            String newValue = new SettingParser().getSettingAsString(properties);
            if (oldValue == null || !StringUtils.equals((String)oldValue, (String)newValue)) {
                this.settingCache.put(WF_LICENSE_SETTING, newValue);
                LOGGER.debug((Object)("setting[WF_LICENSE_SETTING] updated with value[" + newValue + "]"));
                this.notifyChanged(WF_LICENSE_SETTING);
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)"refreshing Neptune setting[WF_LICENSE_SETTING] fail", (Throwable)e);
        }
    }

    private void notifyChanged(String path) {
        Map<String, String> setting = this.getSetting(path);
        for (ISettingUpdateListenter listenter : this.updateListeners) {
            if (!path.equals(listenter.getPath())) continue;
            try {
                listenter.changed(setting);
            }
            catch (Exception e) {
                LOGGER.warn((Object)("failed to update the listner:" + listenter.getPath() + listenter), (Throwable)e);
            }
        }
    }

    public void stop() {
        this.scheduledExecutorService.shutdown();
    }

    public String getServiceName() {
        return RemoteSettingsUpdateNotificationService.class.getName();
    }

    protected ISettingsProvider getSettingsProvider() {
        if (this.settingsProvider == null) {
            SettingsPluginLoader settingsPluginLoader = new SettingsPluginLoader();
            this.settingsProvider = settingsPluginLoader.createSettingsProvider();
        }
        return this.settingsProvider;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public void addUpdateListener(ISettingUpdateListenter listener) {
        this.updateListeners.add(listener);
        this.getNeptuneSettingFetchPath().add(listener.getPath());
    }
}

