/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.message.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.io.DOMReader;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLDocumentUtility {
    private static final Logger LOGGER = Logger.getLogger(XMLDocumentUtility.class);
    private static final ThreadLocal<DocumentBuilder> REUSABLE_BUILDER = new ThreadLocal<DocumentBuilder>(){

        @Override
        protected DocumentBuilder initialValue() {
            try {
                return DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new Error();
            }
        }
    };

    public static void setNodeValue(String expression, String value, XPath xPath, Node n) throws Exception {
        Node node = (Node)xPath.evaluate(expression, n, XPathConstants.NODE);
        node.setTextContent(value);
    }

    public static String getNodeValue(String expression, XPath xPath, Node n) throws Exception {
        if (expression.substring(0, 1).equals("$")) {
            return expression.substring(1);
        }
        Node node = (Node)xPath.evaluate(expression, n, XPathConstants.NODE);
        return node != null ? node.getTextContent() : "";
    }

    public static NodeList getNodeSet(String expression, XPath xPath, org.w3c.dom.Document doc) throws Exception {
        return (NodeList)xPath.evaluate(expression, doc, XPathConstants.NODESET);
    }

    public static String convertToString(Node node, String encoding) throws IOException {
        org.w3c.dom.Document w3cDOM = node instanceof org.w3c.dom.Document ? (org.w3c.dom.Document)org.w3c.dom.Document.class.cast(node) : node.getOwnerDocument();
        DOMReader domReader = new DOMReader();
        Document document = domReader.read(w3cDOM);
        StringWriter w = new StringWriter();
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setIndentSize(4);
        format.setEncoding(encoding);
        XMLWriter xmlWriter = new XMLWriter((Writer)w, format);
        xmlWriter.write(document);
        return w.getBuffer().toString();
    }

    public static String convertToString(Node node) throws IOException {
        org.w3c.dom.Document w3cDOM = node instanceof org.w3c.dom.Document ? (org.w3c.dom.Document)org.w3c.dom.Document.class.cast(node) : node.getOwnerDocument();
        return XMLDocumentUtility.convertToString(node, w3cDOM.getXmlEncoding());
    }

    public static org.w3c.dom.Document loadXml(String xmlString) throws Exception {
        DocumentBuilder builder = REUSABLE_BUILDER.get();
        builder.reset();
        return builder.parse(new InputSource(new StringReader(xmlString)));
    }

    public static org.w3c.dom.Document loadXml(String xmlString, boolean isNSAware) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(isNSAware);
        return factory.newDocumentBuilder().parse(new InputSource(new StringReader(xmlString)));
    }

    public static org.w3c.dom.Document loadFile(ClassLoader classloader, String filePath, boolean validating) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(validating);
        InputStream stream = classloader.getResourceAsStream(filePath);
        return factory.newDocumentBuilder().parse(stream);
    }

    public static org.w3c.dom.Document loadFile(String filePath) throws Exception {
        return XMLDocumentUtility.loadFile(XMLDocumentUtility.class.getClassLoader(), filePath);
    }

    public static org.w3c.dom.Document loadFile(ClassLoader classloader, String filePath) throws Exception {
        return XMLDocumentUtility.loadFile(classloader, filePath, false);
    }

    public static Schema loadSchema(String path) throws SAXException {
        InputStream stream = XMLDocumentUtility.class.getClassLoader().getResourceAsStream(path);
        return SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new StreamSource(stream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(org.w3c.dom.Document document, String filePath) throws IOException {
        DOMReader domReader = new DOMReader();
        Document dom4jDoc = domReader.read(document);
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setNewLineAfterDeclaration(false);
        format.setIndent(true);
        format.setIndentSize(4);
        format.setEncoding(document.getXmlEncoding());
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(new File(filePath));
            XMLWriter xmlWriter = new XMLWriter((OutputStream)fos, format);
            xmlWriter.write(dom4jDoc);
            xmlWriter.flush();
            xmlWriter.close();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    LOGGER.warn((Object)("Failed to close file: " + filePath), (Throwable)e);
                }
            }
        }
    }
}

