/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.monitor.internal;

import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.monitor.core.IObserver;
import com.tandbergtv.workflow.monitor.core.Metric;
import com.tandbergtv.workflow.monitor.core.Recorder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class LoggingRecorder
extends Recorder {
    private static final String FORMAT = "%s.%s.%s.%s.%s %s %d";
    private static final String METRIC_INSTANCE = "workflow";
    private static final String METRIC_TYPE = "application-metrics";
    private static final String METRIC_TYPE_QUEUE = "Queue";
    private static final Pattern RESOURCE_GROUP_DOMAIN_PATTERN = Pattern.compile("^Resource Group (.*)$");
    private static final Logger LOGGER = Logger.getLogger(LoggingRecorder.class);

    public LoggingRecorder(ISchedulerService<Void> pool, String name, int period) {
        super(pool, name, period);
    }

    @Override
    public void record() {
        for (IObserver observer : this.observers) {
            for (Metric metric : observer.getMetrics()) {
                this.log(metric);
            }
        }
    }

    private void log(Metric metric) {
        String s = null;
        switch (metric.getType()) {
            case "Queue": {
                Matcher m = RESOURCE_GROUP_DOMAIN_PATTERN.matcher(metric.getDomain());
                if (!m.find()) break;
                s = String.format(FORMAT, METRIC_TYPE, METRIC_INSTANCE, m.group(1).replaceAll("\\.", "&#46;"), metric.getType().toLowerCase(), "count", metric.getValue(), metric.getTime());
                break;
            }
            default: {
                s = String.format(FORMAT, METRIC_TYPE, METRIC_INSTANCE, metric.getDomain().replaceAll("\\.", "&#46;"), metric.getType(), metric.getName(), metric.getValue(), metric.getTime());
            }
        }
        if (s != null) {
            LOGGER.info(s);
        }
    }
}

