/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.callable;

import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.Cluster;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.IDistributedCache;
import com.tandbergtv.workflow.core.service.thread.DistributedCallable;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ResumeCallable
implements DistributedCallable<Void>,
Serializable {
    private static final long serialVersionUID = 2881259150707825308L;

    public Object getKey() {
        return null;
    }

    public Void call() throws Exception {
        Logger.getLogger(ResumeCallable.class).info((Object)"Resuming...");
        this.setIsHalted(false);
        if (Cluster.isMaster()) {
            IProcessManagerService service = this.getService();
            List<WorkflowProcess> processes = this.getSearchService().findAllByStatus(ProcessStatus.PAUSED);
            for (WorkflowProcess process : processes) {
                service.resume(process.getRootToken());
            }
        }
        return null;
    }

    protected IProcessSearchService getSearchService() {
        return (IProcessSearchService)ServiceRegistry.getDefault().lookup(IProcessSearchService.class);
    }

    protected IDistributedCache<WorkflowProcess> getCache() {
        return (IDistributedCache)ServiceRegistry.getDefault().lookup("Process Cache");
    }

    protected IProcessManagerService getService() {
        return (IProcessManagerService)ServiceRegistry.getDefault().lookup(IProcessManagerService.class);
    }

    protected void setIsHalted(boolean isHalted) {
        IProcessManagerService service = this.getService();
        Properties properties = service.getProperties();
        properties.setProperty("isDriverHalted", Boolean.toString(isHalted));
        try {
            properties.store((OutputStream)null, null);
        }
        catch (Exception e) {
            Logger.getLogger(ResumeCallable.class).warn((Object)"Failed to save the halted state", (Throwable)e);
        }
    }
}

