/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.callable;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.IDistributedCache;
import com.tandbergtv.workflow.core.service.thread.DistributedCallable;
import com.tandbergtv.workflow.driver.internal.monitor.ManualTaskAlarmNotification;
import com.tandbergtv.workflow.driver.internal.monitor.ProcessAlarmNotification;
import com.tandbergtv.workflow.driver.process.ProcessSerializer;
import com.tandbergtv.workflow.driver.process.WorkflowProcessCacheWrapper;
import com.tandbergtv.workflow.monitor.core.alarm.AlarmNotification;
import java.io.Serializable;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;

public class AlarmNotificationCallable
implements DistributedCallable<Set<AlarmNotification>>,
Serializable {
    private static final long serialVersionUID = 1839406027448906847L;
    private final Calendar dateCutoff;

    public AlarmNotificationCallable(Calendar dateCutoff) {
        this.dateCutoff = dateCutoff;
    }

    public Set<AlarmNotification> call() throws Exception {
        HashSet<AlarmNotification> alarms = new HashSet<AlarmNotification>();
        IDistributedCache<WorkflowProcess> cache = this.getLocalCache();
        block0: for (Serializable key : cache.localKeySet()) {
            WorkflowProcessCacheWrapper workflowProcessCacheWrapper = (WorkflowProcessCacheWrapper)((Object)cache.get(key));
            WorkflowProcess process = null;
            if (workflowProcessCacheWrapper != null) {
                process = ProcessSerializer.decode(workflowProcessCacheWrapper.getCache());
            }
            if (process == null) continue;
            ProcessAlarmNotification processAlarmNotificationBuilder = new ProcessAlarmNotification();
            ManualTaskAlarmNotification manualTaskAlarmNotificationBuilder = new ManualTaskAlarmNotification();
            for (CustomToken token : process.findAllTokens()) {
                if (processAlarmNotificationBuilder.match(token, this.dateCutoff)) {
                    AlarmNotification alarm = processAlarmNotificationBuilder.buildAlarm(process);
                    if (alarm == null) continue block0;
                    alarms.add(alarm);
                    continue block0;
                }
                if (!manualTaskAlarmNotificationBuilder.match(token, this.dateCutoff)) continue;
                alarms.addAll(manualTaskAlarmNotificationBuilder.buildAlarmsForProcess(process));
                continue block0;
            }
        }
        return alarms;
    }

    public Object getKey() {
        return null;
    }

    private IDistributedCache<WorkflowProcess> getLocalCache() {
        return (IDistributedCache)ServiceRegistry.getDefault().lookup("Process Cache");
    }
}

