/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.callable;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.graph.ErrorCategory;
import com.tandbergtv.workflow.driver.internal.callable.TokenCallable;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jbpm.JbpmException;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.ExceptionHandler;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.node.ProcessState;
import org.springframework.util.CollectionUtils;

public class NotifySuperProcessToken
extends TokenCallable {
    private long childPid;
    private static final long serialVersionUID = 2429984887044821359L;
    private static final Logger LOGGER = Logger.getLogger(NotifySuperProcessToken.class);

    public NotifySuperProcessToken(CustomToken token, boolean usePid) {
        super(token);
        this.childPid = token.getSubProcessInstance().getId();
        if (usePid) {
            this.key = Long.valueOf(this.getPid());
        }
    }

    @Override
    public CustomToken call() throws Exception {
        CustomToken token = this.findToken();
        if (!this.isSuperProcessToken(token)) {
            LOGGER.warn((Object)(token + ", does not have child " + this.childPid));
            return token;
        }
        Node node = token.getCurrentNode();
        if (!(node instanceof ProcessState)) {
            LOGGER.warn((Object)(token + " currently is not on Process State node."));
            return token;
        }
        boolean isBypassed = this.checkIfBypassException(token);
        if (isBypassed) {
            token.signal2();
        } else {
            node.raiseException((Throwable)new JbpmException(ErrorCategory.CHILD_PROCESS_FAILED.name()), (ExecutionContext)new com.tandbergtv.workflow.core.graph.exe.ExecutionContext((Token)token));
        }
        return token;
    }

    @Override
    protected Callable<CustomToken> innerCallable(CustomToken token) {
        throw new UnsupportedOperationException();
    }

    private boolean isSuperProcessToken(CustomToken token) {
        WorkflowProcess process = token.getSubProcessInstance();
        if (process == null) {
            return false;
        }
        return this.childPid == process.getId();
    }

    private boolean checkIfBypassException(CustomToken token) {
        List exceptionHandlers = token.getProcessInstance().getProcessDefinition().getExceptionHandlers();
        boolean isBypassed = false;
        if (CollectionUtils.isEmpty((Collection)exceptionHandlers)) {
            return isBypassed;
        }
        block0: for (ExceptionHandler exceptionHander : exceptionHandlers) {
            for (Action action : exceptionHander.getActions()) {
                boolean isIgnored = StringUtils.equalsIgnoreCase((String)action.toString(), (String)"IgnoreException");
                boolean isCaught = StringUtils.equalsIgnoreCase((String)action.toString(), (String)"CatchExceptionHandler");
                if (!isIgnored && !isCaught) continue;
                isBypassed = true;
                continue block0;
            }
        }
        return isBypassed;
    }
}

