/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core;

import com.tandbergtv.workflow.auth.domain.IProtectionKeyAware;
import com.tandbergtv.workflow.auth.domain.ProtectionKey;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.InvalidProcessStateException;
import com.tandbergtv.workflow.core.LogLevel;
import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WFSVariableInstance;
import com.tandbergtv.workflow.core.WorkflowProcessNote;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.graph.exe.ExecutionContext;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEvent;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEventType;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.RuntimeAction;
import org.jbpm.graph.log.ProcessInstanceEndLog;
import org.jbpm.instantiation.Delegation;
import org.jbpm.logging.log.ProcessLog;

public class WorkflowProcess
extends ProcessInstance
implements IProtectionKeyAware {
    private static final long serialVersionUID = 5496751459211432922L;
    private ProcessStatus status;
    private ProcessStatus requestedStatus;
    private ProcessPriority priority;
    private Date updateDate;
    private WorkflowProcessNote note;
    private Set<WFSVariableInstance> variables = new HashSet<WFSVariableInstance>();
    private boolean active = true;
    private static final Logger LOGGER = Logger.getLogger(WorkflowProcess.class);
    private Lock lock;

    protected WorkflowProcess() {
        this.lock = new ReentrantLock();
    }

    public WorkflowProcess(ProcessDefinition processDefinition, ProcessPriority processPriority) {
        super(processDefinition);
        this.priority = processPriority;
        this.rootToken = new CustomToken(this);
        this.lock = new ReentrantLock();
        this.addRuntimeActions();
    }

    public WorkflowTemplate getProcessDefinition() {
        return (WorkflowTemplate)super.getProcessDefinition();
    }

    public CustomToken getRootToken() {
        return (CustomToken)this.rootToken;
    }

    public CustomToken getSuperProcessToken() {
        return (CustomToken)this.superProcessToken;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public ProcessStatus getStatus() {
        return this.status;
    }

    void setStatus(ProcessStatus status) {
        if (this.status != null && status != this.status) {
            LOGGER.debug((Object)(this + " -> " + (Object)((Object)status)));
        }
        this.status = status;
    }

    ProcessStatus getRequestedStatus() {
        return this.requestedStatus;
    }

    void setRequestedStatus(ProcessStatus requestedStatus) {
        this.requestedStatus = requestedStatus;
    }

    public ProcessPriority getPriority() {
        return this.priority;
    }

    public void setPriority(ProcessPriority priority) {
        this.priority = priority;
    }

    public WorkflowProcessNote getNote() {
        return this.note;
    }

    public void setNote(WorkflowProcessNote note) {
        this.note = note;
        this.note.setProcess(this);
    }

    public Set<WFSVariableInstance> getVariables() {
        return this.variables;
    }

    private void setVariables(Set<WFSVariableInstance> variables) {
        this.variables = variables;
    }

    @Override
    public void addProtectionKey(ProtectionKey key) {
        throw new UnsupportedOperationException(this + ", adding protection keys is not permitted");
    }

    @Override
    public Set<ProtectionKey> getProtectionKeys() {
        return this.getProcessDefinition().getProtectionKeys();
    }

    public void resetId() {
        this.reset(this);
        this.reset(this.rootToken);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public LogLevel getLogLevel() {
        Object variable = this.getContextInstance().getVariable(LogLevel.LEVEL);
        if (variable instanceof String) {
            return LogLevel.valueOf((String)variable);
        }
        return LogLevel.ALL;
    }

    public void setLogLevel(LogLevel level) {
        this.getContextInstance().setVariable(LogLevel.LEVEL, (Object)level.toString());
    }

    public void delete() {
        if (!this.getCanBeDeleted()) {
            throw new InvalidProcessStateException(this.toString());
        }
        this.active = false;
        this.fireEvent(WorkflowProcessEventType.DELETED);
        for (WorkflowProcess child : this.getSubProcessInstances()) {
            if (child == null) continue;
            child.delete();
        }
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public boolean getCanBeDeleted() {
        ProcessStatus status = this.getRootToken().getStatus();
        return status == ProcessStatus.CANCELLED || status == ProcessStatus.ERROR || status == ProcessStatus.COMPLETED;
    }

    public boolean getCanBePaused() {
        if (this.hasParent()) {
            return false;
        }
        ProcessStatus status = this.getRootToken().getStatus();
        ProcessStatus requestedStatus = this.getRootToken().getRequestedStatus();
        return status != ProcessStatus.PAUSED && requestedStatus != ProcessStatus.PAUSED && status != ProcessStatus.CANCELLED && requestedStatus != ProcessStatus.CANCELLED && status != ProcessStatus.ERROR && status != ProcessStatus.COMPLETED;
    }

    public boolean getCanBeResumed() {
        if (this.hasParent()) {
            return false;
        }
        return this.getRootToken().getStatus() == ProcessStatus.PAUSED;
    }

    public boolean getCanBeRetried() {
        ProcessStatus status = this.getRootToken().getStatus();
        if (status == ProcessStatus.ERROR && !this.hasParent()) {
            return true;
        }
        boolean failed = false;
        for (CustomToken token : this.findAllTokens()) {
            failed = failed || !token.isRoot() && token.getStatus() == ProcessStatus.ERROR && status == ProcessStatus.BRANCHED;
        }
        return failed;
    }

    public boolean getCanBeCancelled() {
        if (this.hasParent()) {
            return false;
        }
        ProcessStatus status = this.getRootToken().getStatus();
        ProcessStatus requestedStatus = this.getRootToken().getRequestedStatus();
        return status != ProcessStatus.CANCELLED && requestedStatus != ProcessStatus.CANCELLED && status != ProcessStatus.COMPLETED;
    }

    public boolean getCanBeRestarted() {
        if (this.hasParent()) {
            return false;
        }
        ProcessStatus status = this.getRootToken().getStatus();
        return status == ProcessStatus.COMPLETED || status == ProcessStatus.CANCELLED || status == ProcessStatus.ERROR;
    }

    public boolean hasParent() {
        return this.getSuperProcessToken() != null;
    }

    public List<CustomToken> findAllTokens() {
        ArrayList<CustomToken> tokens = new ArrayList();
        try {
            tokens = super.findAllTokens();
        }
        catch (ConcurrentModificationException e) {
            LOGGER.warn((Object)(this.rootToken + ", ignoring " + e.getMessage()), (Throwable)e);
        }
        return tokens;
    }

    public Collection<CustomToken> findTokens(ProcessStatus status) {
        ArrayList<CustomToken> tokens = new ArrayList<CustomToken>();
        for (CustomToken token : this.findAllTokens()) {
            if (status != token.getStatus()) continue;
            tokens.add(token);
        }
        return tokens;
    }

    public boolean hasTokens(ProcessStatus status) {
        return !this.findTokens(status).isEmpty();
    }

    public Collection<WorkflowProcess> getSubProcessInstances() {
        ArrayList<WorkflowProcess> subprocesses = new ArrayList<WorkflowProcess>();
        for (CustomToken token : this.findAllTokens()) {
            WorkflowProcess process = token.getSubProcessInstance();
            if (process == null) continue;
            subprocesses.add(token.getSubProcessInstance());
        }
        return subprocesses;
    }

    public boolean hasSubProcessInstances() {
        return !this.getSubProcessInstances().isEmpty();
    }

    public CustomToken findToken(long id) {
        if (this.rootToken.getId() == id) {
            return this.getRootToken();
        }
        for (CustomToken token : this.findAllTokens()) {
            if (token.getId() != id) continue;
            return token;
        }
        throw new InvalidProcessStateException(this.rootToken + ", no token for id " + id);
    }

    public void end() {
        this.rootToken.end();
        if (this.end == null) {
            this.end = new Date();
            this.processDefinition.fireEvent("process-end", (org.jbpm.graph.exe.ExecutionContext)new ExecutionContext(this.rootToken));
            this.rootToken.addLog((ProcessLog)new ProcessInstanceEndLog());
        }
    }

    public void addRuntimeActions() {
        if (this.runtimeActions != null && !this.runtimeActions.isEmpty()) {
            return;
        }
        ResourceBundle bundle = ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".event");
        Enumeration<String> e = bundle.getKeys();
        while (e.hasMoreElements()) {
            String[] classes;
            String event = e.nextElement();
            for (String clazz : classes = bundle.getString(event).split(",")) {
                if (clazz.isEmpty()) continue;
                Delegation delegate = new Delegation(clazz);
                this.addRuntimeAction(new RuntimeAction((GraphElement)this.processDefinition, event, new Action(delegate)));
            }
        }
    }

    private void fireEvent(WorkflowProcessEventType type) {
        DefaultMediator.getInstance().send((WorkflowEvent)new WorkflowProcessEvent((Object)this, this, type));
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.rootToken != null) {
            for (CustomToken token : this.findAllTokens()) {
                if (token.getProcessInstance() == this) continue;
                token.setProcessInstance(this);
            }
        }
    }

    private void reset(Object object) {
        try {
            Field field = object.getClass().getSuperclass().getDeclaredField("id");
            field.setAccessible(true);
            field.set(object, 0);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "[" + this.getId() + "] " + (Object)((Object)this.status);
    }
}

