/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.internal.lifecycle;

import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.IMediator;
import com.tandbergtv.workflow.core.service.Cluster;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.IDistributedCache;
import com.tandbergtv.workflow.core.service.cache.IMultiValueCacheService;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.pluginmanager.PluginManagement;
import com.tandbergtv.workflow.pluginmanager.entities.ResourceGroupDescriptor;
import com.tandbergtv.workflow.pluginmanager.entities.ResourceTypeDescriptor;
import com.tandbergtv.workflow.resourcemanager.ResourceManager;
import com.tandbergtv.workflow.resourcemanager.dataaccess.DataAccessObjectFactory;
import com.tandbergtv.workflow.resourcemanager.dataaccess.ResourceDAI;
import com.tandbergtv.workflow.resourcemanager.dataaccess.ResourceGroupDAI;
import com.tandbergtv.workflow.resourcemanager.dataaccess.ResourceTypeDAI;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceState;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceType;
import com.tandbergtv.workflow.resourcemanager.internal.ICloneService;
import com.tandbergtv.workflow.resourcemanager.internal.IHibernatePersistenceService;
import com.tandbergtv.workflow.resourcemanager.internal.ILocatorService;
import com.tandbergtv.workflow.resourcemanager.internal.ResourceManagementService;
import com.tandbergtv.workflow.resourcemanager.internal.container.IContainerService;
import com.tandbergtv.workflow.resourcemanager.internal.license.ILicenseService;
import com.tandbergtv.workflow.resourcemanager.internal.lifecycle.DistributedCacheInitializedTask;
import com.tandbergtv.workflow.resourcemanager.internal.plugin.IPluginDescriptorMergeService;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.hibernate.Session;

public class LifeCycleManager
extends ResourceManagementService {
    private final ResourceManager resourceManager;
    private boolean distributedCacheInitialized = false;
    private boolean master = false;
    private static final long WAIT_PERIOD = 10000L;
    private static final long TIMEOUT = 60000L;
    private static final Logger LOGGER = Logger.getLogger(LifeCycleManager.class);

    public LifeCycleManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    @Override
    public void start() {
        this.setMaster();
        this.initializeDistributedCache();
        this.waitForDistributedCacheInitialization();
        this.registerColleague();
        this.initializeLocalCache();
    }

    @Override
    public void stop() {
        this.unregisterColleague();
        this.shutdownLocalCache();
    }

    private void setMaster() {
        this.master = Cluster.isMaster();
    }

    private boolean isMaster() {
        return this.master;
    }

    private void initializeDistributedCache() {
        LOGGER.debug((Object)"Resource Manager - Initializing the distributed cache...");
        Session currentSession = this.getPersistenceService().getCurrentSession();
        try {
            currentSession.beginTransaction();
            Map<String, ResourceType> resourceTypes = this.cacheResourceTypes();
            this.cacheResourceGroups(resourceTypes);
            this.cacheResources(resourceTypes);
            currentSession.getTransaction().commit();
        }
        catch (RuntimeException ex) {
            this.getPersistenceService().rollbackTransaction(currentSession);
            throw ex;
        }
        if (this.master) {
            this.setDistributedCacheInitialized();
        }
        LOGGER.info((Object)"Resource Manager - Distributed cache initialized successfully.");
    }

    private Map<String, ResourceType> cacheResourceTypes() {
        HashMap<String, ResourceType> result = new HashMap<String, ResourceType>();
        PluginManagement pluginManager = this.getPluginManager();
        IDistributedCache<ResourceType> cache = this.getResourceTypes();
        DataAccessObjectFactory daoFactory = this.getPersistenceService().getDataAccessObjectFactory();
        ResourceTypeDAI rtDAI = daoFactory.getResourceTypeDAO();
        List resourceTypeList = rtDAI.findAll();
        for (ResourceType resourceType : resourceTypeList) {
            String systemId = resourceType.getSystemId();
            result.put(systemId, resourceType);
            ResourceTypeDescriptor descriptor = pluginManager.getResourceTypeDescriptor(systemId);
            if (descriptor == null) {
                descriptor = pluginManager.getNonLicensedDescriptor(systemId);
            }
            if (descriptor != null) continue;
            resourceType.setPluginMissing(true);
            String msg = "The Resource Type: " + resourceType.getSystemId() + " - " + resourceType.getName() + " [" + resourceType.getId() + "] is not defined by a plugin, and is being marked inactive.";
            LOGGER.warn((Object)msg);
            pluginManager.addMissingResourceTypeDescriptor(resourceType);
        }
        List<ResourceTypeDescriptor> descriptors = pluginManager.getResourceTypeDescriptors();
        for (ResourceTypeDescriptor descriptor : descriptors) {
            this.mergeResourceType(descriptor, result, rtDAI);
        }
        descriptors = pluginManager.getNonLicensedDescriptors();
        for (ResourceTypeDescriptor descriptor : descriptors) {
            this.mergeResourceType(descriptor, result, rtDAI);
        }
        if (this.isMaster()) {
            for (ResourceType resourceType : result.values()) {
                Long resourceTypeId = resourceType.getId();
                cache.add((Serializable)resourceTypeId, (Object)resourceType);
            }
        }
        return result;
    }

    private void mergeResourceType(ResourceTypeDescriptor descriptor, Map<String, ResourceType> resourceTypes, ResourceTypeDAI rtDAI) {
        String systemId = descriptor.getSystemId();
        ResourceType resourceType = resourceTypes.get(systemId);
        ResourceType mergedType = this.getDescriptorMergeService().mergeResourceType(descriptor, resourceType);
        if (mergedType != null) {
            if (this.isMaster()) {
                mergedType = resourceType == null ? rtDAI.create(mergedType) : rtDAI.update(mergedType);
            }
            resourceTypes.put(systemId, mergedType);
        }
    }

    private void cacheResourceGroups(Map<String, ResourceType> resourceTypes) {
        HashMap<String, ResourceGroup> resourceGroups = new HashMap<String, ResourceGroup>();
        PluginManagement pluginManager = this.getPluginManager();
        IMultiValueCacheService<ResourceGroup> cache = this.getResourceGroups();
        DataAccessObjectFactory daoFactory = this.getPersistenceService().getDataAccessObjectFactory();
        ResourceDAI resDAI = daoFactory.getResourceDAO();
        ResourceGroupDAI rgDAI = daoFactory.getResourceGroupDAO();
        List resourceGroupList = rgDAI.findAll();
        for (ResourceGroup resourceGroup : resourceGroupList) {
            String name = resourceGroup.getName();
            resourceGroups.put(name, resourceGroup);
            long resourceTypeId = resourceGroup.getResourceType().getId();
            this.getLocatorService().setResourceTypeIdForGroup(resourceGroup.getId(), resourceTypeId);
            if (pluginManager.getResourceGroupDescriptor(name) != null) continue;
            String systemId = resourceGroup.getResourceType().getSystemId();
            pluginManager.notifyMissingResourceGroup(name, systemId);
        }
        List<ResourceGroupDescriptor> descriptors = pluginManager.getResourceGroupDescriptors();
        for (ResourceGroupDescriptor descriptor : descriptors) {
            ResourceGroup resourceGroup = (ResourceGroup)resourceGroups.get(descriptor.getName());
            ResourceType resourceType = resourceTypes.get(descriptor.getSystemId());
            ResourceGroup mergedGroup = this.getDescriptorMergeService().mergeResourceGroup(descriptor, resourceGroup, resourceType);
            if (mergedGroup == null) continue;
            if (this.isMaster()) {
                if (resourceGroup == null) {
                    mergedGroup = rgDAI.create(mergedGroup);
                    long key = mergedGroup.getId();
                    long resourceTypeId = mergedGroup.getResourceType().getId();
                    this.getLocatorService().setResourceTypeIdForGroup(key, resourceTypeId);
                } else {
                    mergedGroup = rgDAI.update(mergedGroup);
                }
            }
            resourceGroups.put(mergedGroup.getName(), mergedGroup);
        }
        if (this.isMaster()) {
            for (ResourceGroup resourceGroup : resourceGroups.values()) {
                HashSet<Resource> resources = new HashSet<Resource>(resourceGroup.getResources());
                for (Resource resource : resources) {
                    if (resource.getActive()) continue;
                    resourceGroup.removeResource(resource);
                    Resource storedResource = (Resource)resDAI.findByKey(resource.getId());
                    storedResource.removeAllResourceGroups();
                    resDAI.update(storedResource);
                }
                Long resourceTypeId = resourceGroup.getResourceType().getId();
                cache.add((Serializable)resourceTypeId, (Object)this.getCloneService().cloneResourceGroup(resourceGroup));
            }
        }
    }

    private void cacheResources(Map<String, ResourceType> resourceTypes) {
        if (!this.isMaster()) {
            return;
        }
        IMultiValueCacheService<Resource> cache = this.getResources();
        ILicenseService licenseService = this.getLicenseService();
        IHibernatePersistenceService persistenceService = this.getPersistenceService();
        DataAccessObjectFactory factory = persistenceService.getDataAccessObjectFactory();
        ResourceDAI resDAI = factory.getResourceDAO();
        List<Resource> resourceList = resDAI.findByActive(true);
        int systemResources = 0;
        int humanResources = 0;
        for (Resource resource : resourceList) {
            String systemId = resource.getResourceType().getSystemId();
            ResourceType resourceType = resourceTypes.get(systemId);
            ResourceState state = ResourceState.OFFLINE;
            if (resourceType.isNotLicensed()) {
                state = ResourceState.INACTIVE;
            } else if (resourceType.isPluginMissing()) {
                state = ResourceState.INVALID;
            } else if (licenseService.isHumanResource(systemId)) {
                if (++humanResources > licenseService.getMaximumHumanResourceCount()) {
                    state = ResourceState.INVALID;
                }
            } else if (++systemResources > licenseService.getMaximumSystemResourceCount()) {
                state = ResourceState.INVALID;
            }
            resource.setOperationalState(state);
            LOGGER.debug((Object)(resource.getName() + " set to " + state.getStateName()));
            resource = resDAI.update(resource);
            Long resourceTypeId = resource.getResourceType().getId();
            cache.add((Serializable)resourceTypeId, (Object)this.getCloneService().cloneResource(resource));
        }
        licenseService.setSystemResourceCount(systemResources);
        licenseService.setHumanResourceCount(humanResources);
    }

    public synchronized boolean isDistributedCacheInitialized() {
        return this.distributedCacheInitialized;
    }

    synchronized void setDistributedCacheInitialized() {
        this.distributedCacheInitialized = true;
    }

    private void waitForDistributedCacheInitialization() {
        long start = System.currentTimeMillis();
        while (!this.isDistributedCacheInitialized()) {
            try {
                DistributedCacheInitializedTask task = new DistributedCacheInitializedTask();
                Future future = this.getScheduler().schedule((Callable)((Object)task));
                Boolean result = (Boolean)future.get(60000L, TimeUnit.MILLISECONDS);
                if (result != null && result.booleanValue()) {
                    this.setDistributedCacheInitialized();
                    return;
                }
                Thread.sleep(10000L);
            }
            catch (Exception e) {
                String msg = "Failure determining if master resource management service has initialized distributed cache.";
                LOGGER.warn((Object)msg, (Throwable)e);
            }
            if (System.currentTimeMillis() - start < 60000L) continue;
            String msg = "Timeout waiting for master resource management service to initialize distributed cache.";
            throw new RuntimeException(msg);
        }
    }

    private void initializeLocalCache() {
        IContainerService containerCacheService = this.getContainerService();
        Collection localKeys = this.getResourceTypes().localKeySet();
        for (Serializable key : localKeys) {
            containerCacheService.initializeContainers(key);
        }
    }

    private void shutdownLocalCache() {
        this.getContainerService().shutdownContainers();
    }

    private void registerColleague() {
        this.getMediator().register((IColleague)this.resourceManager);
    }

    private void unregisterColleague() {
        this.getMediator().unregister((IColleague)this.resourceManager);
    }

    private IMediator getMediator() {
        return DefaultMediator.getInstance();
    }

    private PluginManagement getPluginManager() {
        return (PluginManagement)ServiceRegistry.getDefault().lookup(PluginManagement.class);
    }

    private IHibernatePersistenceService getPersistenceService() {
        return this.getService(IHibernatePersistenceService.class);
    }

    private IDistributedCache<ResourceType> getResourceTypes() {
        return (IDistributedCache)this.getService("WFS:ResourceTypeCache");
    }

    private IMultiValueCacheService<ResourceGroup> getResourceGroups() {
        return (IMultiValueCacheService)this.getService("WFS:ResourceGroupCache");
    }

    private IMultiValueCacheService<Resource> getResources() {
        return (IMultiValueCacheService)this.getService("WFS:ResourceCache");
    }

    private ICloneService getCloneService() {
        return this.getService(ICloneService.class);
    }

    private ILicenseService getLicenseService() {
        return this.getService(ILicenseService.class);
    }

    private IPluginDescriptorMergeService getDescriptorMergeService() {
        return this.getService(IPluginDescriptorMergeService.class);
    }

    private IContainerService getContainerService() {
        return this.getService(IContainerService.class);
    }

    private ILocatorService getLocatorService() {
        return this.getService(ILocatorService.class);
    }

    private ISchedulerService<Boolean> getScheduler() {
        return (ISchedulerService)this.getService("WFS:ResourceManagementEventScheduler");
    }
}

