/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.internal.container;

import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.core.service.cache.IDistributedCache;
import com.tandbergtv.workflow.core.service.cache.IMultiValueCacheService;
import com.tandbergtv.workflow.resourcemanager.LocalCacheNotReadyException;
import com.tandbergtv.workflow.resourcemanager.ResourceContainer;
import com.tandbergtv.workflow.resourcemanager.ResourceGroupContainer;
import com.tandbergtv.workflow.resourcemanager.ResourceTypeContainer;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceEntity;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceType;
import com.tandbergtv.workflow.resourcemanager.internal.ICloneService;
import com.tandbergtv.workflow.resourcemanager.internal.ResourceManagementService;
import com.tandbergtv.workflow.resourcemanager.internal.container.IContainerService;
import com.tandbergtv.workflow.resourcemanager.internal.container.IResourceManagementContainer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class ResourceManagementContainerService
extends ResourceManagementService
implements IContainerService {
    @Override
    public void initializeContainers(Serializable resourceTypeId) {
        ResourceTypeContainer typeContainer = this.cacheResourceTypeContainer(resourceTypeId);
        Collection<ResourceGroupContainer> groupContainers = this.cacheResourceGroupContainers(resourceTypeId);
        Collection<ResourceContainer> resourceContainers = this.cacheResourceContainers(resourceTypeId);
        for (ResourceContainer resourceContainer : resourceContainers) {
            this.startContainer(resourceContainer);
        }
        for (ResourceGroupContainer groupContainer : groupContainers) {
            this.startContainer(groupContainer);
        }
        if (typeContainer != null) {
            this.startContainer(typeContainer);
        }
    }

    @Override
    public void shutdownContainers(Serializable resourceTypeId) {
        if (resourceTypeId == null) {
            throw new IllegalArgumentException("The resource type ID cannot be null when shutting down container cache.");
        }
        this.internalShutdownContainerCache(resourceTypeId);
    }

    @Override
    public void shutdownContainers() {
        this.internalShutdownContainerCache(null);
    }

    @Override
    public ResourceTypeContainer createResourceTypeContainer(ResourceType resourceType) {
        resourceType = this.getCloneService().cloneResourceType(resourceType);
        ResourceTypeContainer container = new ResourceTypeContainer(resourceType);
        this.cacheCreatedContainer(this.getResourceTypeContainers(), container);
        return container;
    }

    @Override
    public ResourceGroupContainer createResourceGroupContainer(ResourceGroup resourceGroup) {
        resourceGroup = this.getCloneService().cloneResourceGroup(resourceGroup);
        ResourceGroupContainer container = new ResourceGroupContainer(resourceGroup);
        this.cacheCreatedContainer(this.getResourceGroupContainers(), container);
        return container;
    }

    @Override
    public ResourceContainer createResourceContainer(Resource resource) {
        resource = this.getCloneService().cloneResource(resource);
        ResourceContainer container = new ResourceContainer(resource);
        this.cacheCreatedContainer(this.getResourceContainers(), container);
        return container;
    }

    @Override
    public ResourceContainer deleteResourceContainer(long resourceId) {
        Long key = new Long(resourceId);
        ResourceContainer container = this.removeContainer(this.getResourceContainers(), key, false);
        if (container != null) {
            Long distributedKey = ((Resource)container.getEntity()).getResourceType().getId();
            this.getResources().remove((Serializable)distributedKey, container.getEntity());
        }
        return container;
    }

    @Override
    public void verifyContainerReady(IResourceManagementContainer<? extends ResourceEntity> container) {
        String name = container != null ? container.toString() : "UNKNOWN";
        this.verifyContainerReady(name, container);
    }

    @Override
    public void verifyContainerReady(String name, IResourceManagementContainer<? extends ResourceEntity> container) {
        if (container == null) {
            throw new LocalCacheNotReadyException(name + " is not present in local cache.");
        }
        if (container.isStopped()) {
            throw new LocalCacheNotReadyException(name + " has been removed from local cache.");
        }
    }

    private ResourceTypeContainer cacheResourceTypeContainer(Serializable resourceTypeId) {
        ResourceType resourceType = (ResourceType)this.getResourceTypes().get(resourceTypeId);
        if (resourceType != null) {
            resourceType = this.getCloneService().cloneResourceType(resourceType);
            ResourceTypeContainer container = new ResourceTypeContainer(resourceType);
            this.cacheContainer(this.getResourceTypeContainers(), container);
            return container;
        }
        return null;
    }

    private Collection<ResourceGroupContainer> cacheResourceGroupContainers(Serializable resourceTypeId) {
        Collection groups = this.getResourceGroups().get(resourceTypeId);
        ArrayList<ResourceGroupContainer> containers = new ArrayList<ResourceGroupContainer>();
        if (groups != null) {
            ICacheService<ResourceGroupContainer> cache = this.getResourceGroupContainers();
            for (ResourceGroup resourceGroup : groups) {
                if (resourceGroup == null) continue;
                resourceGroup = this.getCloneService().cloneResourceGroup(resourceGroup);
                ResourceGroupContainer container = new ResourceGroupContainer(resourceGroup);
                this.cacheContainer(cache, container);
                containers.add(container);
            }
        }
        return containers;
    }

    private Collection<ResourceContainer> cacheResourceContainers(Serializable resourceTypeId) {
        Collection resources = this.getResources().get(resourceTypeId);
        ArrayList<ResourceContainer> containers = new ArrayList<ResourceContainer>();
        if (resources != null) {
            ICacheService<ResourceContainer> cache = this.getResourceContainers();
            for (Resource resource : resources) {
                if (resource == null) continue;
                resource = this.getCloneService().cloneResource(resource);
                ResourceContainer container = new ResourceContainer(resource);
                this.cacheContainer(cache, container);
                containers.add(container);
            }
        }
        return containers;
    }

    private <C extends IResourceManagementContainer<?>> void cacheContainer(ICacheService<C> cache, C container) {
        this.cacheContainer(cache, container, false, false);
    }

    private <C extends IResourceManagementContainer<?>> void cacheCreatedContainer(ICacheService<C> cache, C container) {
        this.cacheContainer(cache, container, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <C extends IResourceManagementContainer<?>> void cacheContainer(ICacheService<C> cache, C container, boolean start, boolean update) {
        container.setRegistry(this.getRegistry());
        container.initialize();
        if (update) {
            container.updateEntity();
        }
        if (start) {
            container.getWriteLock().lock();
        }
        try {
            cache.add(container.getKey(), container);
            if (start) {
                container.start();
            }
        }
        finally {
            if (start) {
                container.getWriteLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startContainer(IResourceManagementContainer<? extends ResourceEntity> container) {
        container.getWriteLock().lock();
        try {
            if (!container.isStarted() && !container.isStopped()) {
                container.start();
            }
        }
        finally {
            container.getWriteLock().unlock();
        }
    }

    private void internalShutdownContainerCache(Serializable resourceTypeId) {
        Collection<Serializable> keys = null;
        keys = this.getKeys(this.getResourceTypeContainers(), resourceTypeId);
        this.removeContainers(this.getResourceTypeContainers(), keys);
        keys = this.getKeys(this.getResourceGroupContainers(), resourceTypeId);
        this.removeContainers(this.getResourceGroupContainers(), keys);
        keys = this.getKeys(this.getResourceContainers(), resourceTypeId);
        this.removeContainers(this.getResourceContainers(), keys);
    }

    private <C extends IResourceManagementContainer<?>> Collection<Serializable> getKeys(ICacheService<C> cache, Serializable resourceTypeId) {
        HashSet<Serializable> matchingKeys = new HashSet<Serializable>();
        Collection keys = cache.getKeys();
        if (keys == null) {
            return matchingKeys;
        }
        if (resourceTypeId == null) {
            matchingKeys.addAll(keys);
        } else {
            for (Serializable key : keys) {
                IResourceManagementContainer container = (IResourceManagementContainer)cache.get(key);
                if (container == null || !resourceTypeId.equals(container.getResourceTypeId())) continue;
                matchingKeys.add(key);
            }
        }
        return matchingKeys;
    }

    private <C extends IResourceManagementContainer<?>> void removeContainers(ICacheService<C> cache, Collection<Serializable> keys) {
        for (Serializable key : keys) {
            this.removeContainer(cache, key, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <C extends IResourceManagementContainer<?>> C removeContainer(ICacheService<C> cache, Serializable key, boolean destroy) {
        IResourceManagementContainer container = (IResourceManagementContainer)cache.get(key);
        if (container != null) {
            boolean stopped = false;
            container.getWriteLock().lock();
            try {
                if (!container.isStopped()) {
                    container.stop();
                    stopped = true;
                }
                cache.remove(key);
            }
            finally {
                container.getWriteLock().unlock();
            }
            if (stopped && destroy) {
                container.destroy();
            }
        }
        return (C)container;
    }

    private IDistributedCache<ResourceType> getResourceTypes() {
        return (IDistributedCache)this.getService("WFS:ResourceTypeCache");
    }

    private IMultiValueCacheService<ResourceGroup> getResourceGroups() {
        return (IMultiValueCacheService)this.getService("WFS:ResourceGroupCache");
    }

    private IMultiValueCacheService<Resource> getResources() {
        return (IMultiValueCacheService)this.getService("WFS:ResourceCache");
    }

    private ICacheService<ResourceTypeContainer> getResourceTypeContainers() {
        return (ICacheService)this.getService("ResourceTypeContainerCache");
    }

    private ICacheService<ResourceGroupContainer> getResourceGroupContainers() {
        return (ICacheService)this.getService("ResourceGroupContainerCache");
    }

    private ICacheService<ResourceContainer> getResourceContainers() {
        return (ICacheService)this.getService("ResourceContainerCache");
    }

    private ICloneService getCloneService() {
        return this.getService(ICloneService.class);
    }
}

