/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.internal.activator;

import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.CacheService;
import com.tandbergtv.workflow.core.service.internal.DistributedCache;
import com.tandbergtv.workflow.core.service.internal.DistributedMultiValueCache;
import com.tandbergtv.workflow.core.service.internal.RecoverableDistributedScheduler;
import com.tandbergtv.workflow.resourcemanager.LocalCacheNotReadyException;
import com.tandbergtv.workflow.resourcemanager.ResourceManagementNotReadyException;
import com.tandbergtv.workflow.resourcemanager.ResourceManager;
import com.tandbergtv.workflow.resourcemanager.ResourceStateManager;
import com.tandbergtv.workflow.resourcemanager.internal.DistributedServiceTaskExecutor;
import com.tandbergtv.workflow.resourcemanager.internal.ICloneService;
import com.tandbergtv.workflow.resourcemanager.internal.IDistributedServiceTaskExecutor;
import com.tandbergtv.workflow.resourcemanager.internal.IHibernatePersistenceService;
import com.tandbergtv.workflow.resourcemanager.internal.ILocatorService;
import com.tandbergtv.workflow.resourcemanager.internal.IResourceManagementService;
import com.tandbergtv.workflow.resourcemanager.internal.ResourceManagementCloneService;
import com.tandbergtv.workflow.resourcemanager.internal.ResourceManagementLocatorService;
import com.tandbergtv.workflow.resourcemanager.internal.ResourceManagementPersistenceService;
import com.tandbergtv.workflow.resourcemanager.internal.allocation.IResourceAllocationService;
import com.tandbergtv.workflow.resourcemanager.internal.allocation.ResourceAllocationService;
import com.tandbergtv.workflow.resourcemanager.internal.container.IContainerService;
import com.tandbergtv.workflow.resourcemanager.internal.container.ResourceManagementContainerMonitor;
import com.tandbergtv.workflow.resourcemanager.internal.container.ResourceManagementContainerService;
import com.tandbergtv.workflow.resourcemanager.internal.event.DistributedEventHandler;
import com.tandbergtv.workflow.resourcemanager.internal.event.LocalEventHandler;
import com.tandbergtv.workflow.resourcemanager.internal.event.LocalEventScheduler;
import com.tandbergtv.workflow.resourcemanager.internal.license.ILicenseService;
import com.tandbergtv.workflow.resourcemanager.internal.license.ResourceManagementLicenseService;
import com.tandbergtv.workflow.resourcemanager.internal.lifecycle.LifeCycleManager;
import com.tandbergtv.workflow.resourcemanager.internal.plugin.IPluginDescriptorChangeHandler;
import com.tandbergtv.workflow.resourcemanager.internal.plugin.IPluginDescriptorMergeService;
import com.tandbergtv.workflow.resourcemanager.internal.plugin.PluginDescriptorChangeHandler;
import com.tandbergtv.workflow.resourcemanager.internal.plugin.PluginDescriptorMergeService;
import com.tandbergtv.workflow.resourcemanager.internal.resource.DistributedResourceService;
import com.tandbergtv.workflow.resourcemanager.internal.resource.LocalResourceService;
import com.tandbergtv.workflow.resourcemanager.internal.resourcegroup.DistributedResourceGroupService;
import com.tandbergtv.workflow.resourcemanager.internal.resourcegroup.LocalResourceGroupService;
import com.tandbergtv.workflow.resourcemanager.internal.resourcetype.DistributedResourceTypeService;
import com.tandbergtv.workflow.resourcemanager.internal.resourcetype.LocalResourceTypeService;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.hibernate.SessionFactory;

public final class ResourceManagementActivator {
    private static final String DISTRIBUTED_UI_POOL_SIZE = "resourcemanagement.uischeduler.pool.size";
    private static final String DISTRIBUTED_UI_RECOVERYPOOL_SIZE = "resourcemanagement.uischeduler.recoverypool.size";
    private static final String DISTRIBUTED_EVENT_POOL_SIZE = "resourcemanagement.eventscheduler.pool.size";
    private static final String DISTRIBUTED_EVENT_RECOVERYPOOL_SIZE = "resourcemanagement.eventscheduler.recoverypool.size";
    private static final String LOCAL_EVENT_POOL_SIZE = "resourcemanagement.localEvents.pool.size";
    private static final String LOCAL_EVENT_POOL_MAX = "resourcemanagement.localEvents.pool.max";
    private static final String MONITOR_START_DELAY = "resourcemanagement.containerCacheMonitor.startDelay";
    private static final String MONITOR_FREQUENCY = "resourcemanagement.containerCacheMonitor.frequency";
    private final ResourceManager manager;
    private final Map<String, Object> serviceProperties;
    private final ServiceRegistry registry;

    public ResourceManagementActivator(ResourceManager manager, Map<String, Object> properties, ServiceRegistry registry) {
        this.manager = manager;
        this.serviceProperties = properties == null ? new HashMap() : properties;
        this.registry = registry;
    }

    public void start() {
        String packageName = this.getClass().getPackage().getName();
        ResourceBundle bundle = ResourceBundle.getBundle(packageName + ".service");
        SessionFactory sessionFactory = (SessionFactory)this.serviceProperties.get("SessionFactory");
        this.addService(new ResourceManagementPersistenceService(sessionFactory));
        int systemResourceLimit = (Integer)this.serviceProperties.get("SystemResourceLimit");
        int humanResourceLimit = (Integer)this.serviceProperties.get("HumanResourceLimit");
        this.addService(new ResourceManagementLicenseService(systemResourceLimit, humanResourceLimit));
        int size = Integer.parseInt(bundle.getString(LOCAL_EVENT_POOL_SIZE));
        int max = Integer.parseInt(bundle.getString(LOCAL_EVENT_POOL_MAX));
        this.addService(new LocalEventScheduler(size, max));
        RecoverableDistributedScheduler scheduler = null;
        size = Integer.parseInt(bundle.getString(DISTRIBUTED_EVENT_POOL_SIZE));
        int recoverySize = Integer.parseInt(bundle.getString(DISTRIBUTED_EVENT_RECOVERYPOOL_SIZE));
        scheduler = new RecoverableDistributedScheduler("WFS:ResourceManagementEventScheduler", size, recoverySize);
        scheduler.addRecoverableError(LocalCacheNotReadyException.class);
        scheduler.addRecoverableError(ResourceManagementNotReadyException.class);
        this.addService((Service)scheduler);
        size = Integer.parseInt(bundle.getString(DISTRIBUTED_UI_POOL_SIZE));
        recoverySize = Integer.parseInt(bundle.getString(DISTRIBUTED_UI_RECOVERYPOOL_SIZE));
        scheduler = new RecoverableDistributedScheduler("WFS:ResourceManagementUIScheduler", size, recoverySize);
        scheduler.addRecoverableError(LocalCacheNotReadyException.class);
        scheduler.addRecoverableError(ResourceManagementNotReadyException.class);
        this.addService((Service)scheduler);
        this.addService((Service)new DistributedCache("WFS:ResourceTypeCache"));
        this.addService((Service)new DistributedMultiValueCache("WFS:ResourceGroupCache"));
        this.addService((Service)new DistributedMultiValueCache("WFS:ResourceCache"));
        size = Integer.MAX_VALUE;
        this.addService((Service)new CacheService("ResourceTypeContainerCache", size));
        this.addService((Service)new CacheService("ResourceGroupContainerCache", size));
        this.addService((Service)new CacheService("ResourceContainerCache", size));
        this.addService(new LocalEventHandler());
        this.addService(new DistributedEventHandler());
        this.addService(new DistributedServiceTaskExecutor());
        this.addService(new LocalResourceTypeService());
        this.addService(new LocalResourceGroupService());
        this.addService(new LocalResourceService());
        this.addService(new DistributedResourceTypeService());
        this.addService(new DistributedResourceGroupService());
        this.addService(new DistributedResourceService());
        this.addService(new PluginDescriptorChangeHandler());
        this.addService(new PluginDescriptorMergeService());
        this.addService(new ResourceManagementCloneService());
        this.addService(new ResourceManagementContainerService());
        this.addService(new ResourceManagementLocatorService());
        this.addService(new ResourceStateManager());
        this.addService(new ResourceAllocationService());
        int delay = Integer.parseInt(bundle.getString(MONITOR_START_DELAY));
        int frequency = Integer.parseInt(bundle.getString(MONITOR_FREQUENCY));
        this.addService(new ResourceManagementContainerMonitor(delay, frequency));
        this.addService(new LifeCycleManager(this.manager));
    }

    public void stop() {
        this.removeService(LifeCycleManager.class);
        this.removeService(ResourceManagementContainerMonitor.class);
        this.removeService(IResourceAllocationService.class);
        this.removeService(ResourceStateManager.class);
        this.removeService(ILocatorService.class);
        this.removeService(IContainerService.class);
        this.removeService(ICloneService.class);
        this.removeService(IPluginDescriptorMergeService.class);
        this.removeService(IPluginDescriptorChangeHandler.class);
        this.removeService("DistributedResourceService");
        this.removeService("DistributedResourceGroupService");
        this.removeService("DistributedResourceTypeService");
        this.removeService("LocalResourceService");
        this.removeService("LocalResourceGroupService");
        this.removeService("LocalResourceTypeService");
        this.removeService(IDistributedServiceTaskExecutor.class);
        this.removeService("ResourceManagementDistributedEventHandler");
        this.removeService("ResourceManagementLocalEventHandler");
        this.removeService("ResourceContainerCache");
        this.removeService("ResourceGroupContainerCache");
        this.removeService("ResourceTypeContainerCache");
        this.removeService("WFS:ResourceCache");
        this.removeService("WFS:ResourceGroupCache");
        this.removeService("WFS:ResourceTypeCache");
        this.removeService("WFS:ResourceManagementUIScheduler");
        this.removeService("WFS:ResourceManagementEventScheduler");
        this.removeService("resource-localEvents");
        this.removeService(ILicenseService.class);
        this.removeService(IHibernatePersistenceService.class);
    }

    public ServiceRegistry getRegistry() {
        return this.registry;
    }

    private void addService(Service service) {
        if (service instanceof IResourceManagementService) {
            ((IResourceManagementService)service).setRegistry(this.registry);
        }
        this.registry.register(service.getServiceName(), service);
        service.start();
    }

    private void removeService(Class<? extends Service> clazz) {
        this.removeService((Service)this.registry.lookup(clazz));
    }

    private void removeService(String name) {
        this.removeService(this.registry.lookup(name));
    }

    private void removeService(Service service) {
        if (service != null) {
            service.stop();
            this.registry.unregister(service);
        }
    }
}

