/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.mgmt.initialization;

import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.comm.routing.IRoutingService;
import com.tandbergtv.workflow.comm.routing.RoutingServiceFactory;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.message.WorkflowPayload;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.mgmt.initialization.AbstractInitializationStrategy;
import com.tandbergtv.workflow.resourcemanager.mgmt.initialization.ResourceInitializationEvent;
import com.tandbergtv.workflow.util.DeviceTypeUtil;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public abstract class MessageSendingIS
extends AbstractInitializationStrategy {
    private static final Logger LOGGER = Logger.getLogger(MessageSendingIS.class);
    public static final String MESSAGE_UID_KEY = "_messageUID";
    public static final String PAYLOAD_PROPERTIES_KEY = "_payloadProperties";
    public static final String ERROR_MESSAGE_KEY = "_errorMessageProperty";
    public static final String RETRY_DELAY_KEY = "_retryDelay";
    public static final String FAILURE_THRESHOLD_KEY = "_failureThreshold";

    protected WorkflowMessage constructInitializationMessage() {
        String messageUID = this.getConfiguration().get(MESSAGE_UID_KEY);
        WorkflowMessage message = WorkflowMessageFactory.createControlMessage((String)messageUID);
        this.constructMessagePayload(message);
        return message;
    }

    protected void constructMessagePayload(WorkflowMessage message) {
        if (message == null) {
            return;
        }
        String payloadProperties = this.getConfiguration().get(PAYLOAD_PROPERTIES_KEY);
        WorkflowPayload payload = message.getPayload();
        if (payloadProperties != null) {
            String[] properties;
            for (String property : properties = payloadProperties.split(",")) {
                if ((property = property.trim()).length() <= 0) continue;
                String value = this.getConfiguration().get(property);
                payload.putValue(property, value);
            }
        }
    }

    protected abstract boolean isInitializationComplete(WorkflowMessage var1);

    protected boolean isInitializationError(WorkflowMessage response) {
        return response == null || !WorkflowMessage.MessageType.ack.equals((Object)response.getType());
    }

    protected String getErrorMessageKey() {
        String key = null;
        key = this.getConfiguration().get(ERROR_MESSAGE_KEY);
        return key;
    }

    protected String getErrorMessageInResponse(WorkflowMessage response) {
        String message = "";
        String key = this.getErrorMessageKey();
        if (key == null) {
            return message;
        }
        if (response != null && response.getPayload() != null) {
            WorkflowPayload payload = response.getPayload();
            message = payload.getValue(key);
        }
        return message;
    }

    protected int getInitializationFailureThreshold() {
        int threshold = 1;
        String value = this.getConfiguration().get(FAILURE_THRESHOLD_KEY);
        try {
            if (value != null && (threshold = Integer.parseInt(value)) < 1) {
                threshold = 1;
            }
        }
        catch (NumberFormatException nfe) {
            threshold = 1;
        }
        return threshold;
    }

    @Override
    protected Runnable getInitializationCommand() {
        return new MessageSendCommand();
    }

    @Override
    protected long getInitializationRetryDelay() {
        long delay = 30L;
        try {
            String value = this.getConfiguration().get(RETRY_DELAY_KEY);
            if (value != null) {
                delay = Long.parseLong(value);
            }
        }
        catch (Exception ex) {
            delay = 30L;
        }
        return delay;
    }

    class MessageSendCommand
    implements Runnable {
        private int consecutiveFailures = 0;

        MessageSendCommand() {
        }

        @Override
        public void run() {
            Resource resource = MessageSendingIS.this.getResource();
            IDestination destination = (IDestination)DeviceTypeUtil.createDevice(resource);
            ArrayList<IDestination> targetDestinations = new ArrayList<IDestination>();
            targetDestinations.add(destination);
            String name = "Resource[id=" + resource.getId() + "]: " + resource.getName();
            try {
                ResourceInitializationEvent event;
                WorkflowMessage response = null;
                String errorMessage = null;
                Exception error = null;
                boolean isFailed = false;
                try {
                    LOGGER.debug((Object)("Sending Initialization Message for " + name));
                    WorkflowMessage message = MessageSendingIS.this.constructInitializationMessage();
                    RoutingServiceFactory factory = RoutingServiceFactory.newInstance();
                    IRoutingService service = factory.createRoutingService();
                    response = service.send(message, targetDestinations);
                }
                catch (Exception ex) {
                    isFailed = true;
                    int failureCount = this.consecutiveFailures + 1;
                    errorMessage = "Initialization Error for " + name + " when attempting to send message to the Adaptor " + "(Consecutive Error Count=" + failureCount + ").";
                    error = ex;
                }
                if (isFailed) {
                    ++this.consecutiveFailures;
                } else if (MessageSendingIS.this.isInitializationError(response)) {
                    ++this.consecutiveFailures;
                    String msg = MessageSendingIS.this.getErrorMessageInResponse(response);
                    errorMessage = "Initialization Error for " + name + ": " + msg;
                } else {
                    this.consecutiveFailures = 0;
                    if (MessageSendingIS.this.isInitializationComplete(response)) {
                        event = this.createEvent(null, null);
                        MessageSendingIS.this.fireInitializationSuccessEvent(event);
                    }
                }
                if (this.consecutiveFailures >= MessageSendingIS.this.getInitializationFailureThreshold()) {
                    event = this.createEvent(errorMessage, error);
                    MessageSendingIS.this.fireInitializationFailureEvent(event);
                } else if (this.consecutiveFailures > 0) {
                    if (error != null) {
                        LOGGER.warn((Object)errorMessage, (Throwable)error);
                    } else {
                        LOGGER.warn((Object)errorMessage);
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.error((Object)("Failure in the Initialization Thread for " + name + ", this should never happen."), (Throwable)ex);
            }
        }

        private ResourceInitializationEvent createEvent(String message, Throwable error) {
            ResourceInitializationEvent event = null;
            MessageSendingIS source = MessageSendingIS.this;
            Resource resource = MessageSendingIS.this.getResource();
            event = new ResourceInitializationEvent(source, resource, message, error);
            return event;
        }
    }
}

