/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.service;

import com.tandbergtv.workflow.core.service.Service;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ServiceRegistry {
    private Map<String, Service> map = new ConcurrentHashMap<String, Service>();
    private static final ServiceRegistry REGISTRY = new ServiceRegistry();

    private ServiceRegistry() {
    }

    public void register(String name, Service service) {
        this.map.put(name, service);
    }

    public void unregister(String name) {
        this.map.remove(name);
    }

    public void unregister(Service service) {
        Iterator<Service> i = this.map.values().iterator();
        while (i.hasNext()) {
            Service s = i.next();
            if (s != service) continue;
            i.remove();
        }
    }

    public Service lookup(String name) {
        return this.map.get(name);
    }

    public <T> T lookup(Class<T> clazz) {
        for (Service service : this.map.values()) {
            if (!clazz.isAssignableFrom(service.getClass())) continue;
            return clazz.cast(service);
        }
        return (T)((Object)null);
    }

    public static ServiceRegistry getDefault() {
        return REGISTRY;
    }

    public static ServiceRegistry createRegistry() {
        return new ServiceRegistry();
    }
}

