/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.licensing.generator;

import com.tandbergtv.workflow.core.licensing.generator.ILicenseGenerator;
import com.tandbergtv.workflow.core.licensing.generator.LicenseNotGeneratedException;
import com.tandbergtv.workflow.util.encryption.EncryptionUtil;
import java.io.File;

public class FileLicenseGenerator
implements ILicenseGenerator {
    private String licenseKeyFilePath;
    private static final String ENCRYPTED_FILE_NAME = "licensekey.lic";

    private String getConfigPath() throws LicenseNotGeneratedException {
        String root = System.getProperty("com.tandbergtv.cms.product.dir");
        if (root == null || root.trim().length() == 0) {
            throw new LicenseNotGeneratedException("com.tandbergtv.cms.product.dir not specified in VM arguments");
        }
        String configPath = root + File.separator + "conf" + File.separator + "workflow";
        return configPath;
    }

    public void setFileName(String fileName) throws LicenseNotGeneratedException {
        String configPath = this.getConfigPath();
        String filePath = null;
        this.licenseKeyFilePath = filePath = configPath.trim() + File.separator + fileName.trim();
    }

    @Override
    public void generateAndSave(String password) throws LicenseNotGeneratedException {
        EncryptionUtil encUtil = new EncryptionUtil();
        String configPath = this.getConfigPath();
        String encrFilePath = configPath.trim() + File.separator + ENCRYPTED_FILE_NAME;
        encUtil.encryptToFile(password, this.licenseKeyFilePath, encrFilePath);
    }
}

