/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEvent;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEventType;
import com.tandbergtv.workflow.driver.event.message.MessageRejectedEvent;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import com.tandbergtv.workflow.resourcemanager.event.QueueOrderChangedEvent;
import com.tandbergtv.workflow.resourcemanager.event.ResourceAcquiredEvent;
import com.tandbergtv.workflow.resourcemanager.event.ResourceAllocationFailedEvent;
import com.tandbergtv.workflow.resourcemanager.event.ResourceFailedEvent;
import com.tandbergtv.workflow.resourcemanager.event.ResourceRequestRejectedEvent;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.exe.Token;

public final class EngineDriver
implements IColleague {
    private static EngineDriver instance;
    private Properties properties;
    private int maxRetryAttempts;
    private static final Logger logger;
    private static final String ALLOCATED_RESOURCE_KEY_VARIABLE = "_allocated_resource_";

    private EngineDriver() {
    }

    public static synchronized EngineDriver getInstance() {
        if (instance == null) {
            instance = new EngineDriver();
        }
        return instance;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
        try {
            this.maxRetryAttempts = Integer.parseInt(this.properties.getProperty("driver.max.retry.attempts"));
        }
        catch (NumberFormatException e) {
            this.maxRetryAttempts = 3;
        }
    }

    private IProcessManagerService getProcessManagerService() {
        return (IProcessManagerService)ServiceRegistry.getDefault().lookup(IProcessManagerService.class);
    }

    private void save(WorkflowProcess process) {
        ((IPersistenceService)ServiceRegistry.getDefault().lookup(IPersistenceService.class)).save(process);
    }

    public String getColleagueName() {
        return this.getClass().getName();
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.NORMAL;
    }

    public void receive(WorkflowEvent event) {
        Object source = event.getSource();
        if (source == this) {
            return;
        }
        if (event instanceof ResourceAcquiredEvent) {
            ResourceAcquiredEvent e = (ResourceAcquiredEvent)event;
            CustomToken token = (CustomToken)e.getToken();
            if (token.getStatus() == ProcessStatus.QUEUED) {
                logger.debug((Object)(token + " got resource"));
                String name = ALLOCATED_RESOURCE_KEY_VARIABLE + token.getId();
                String value = e.getAllocatedResourceKey();
                WorkflowProcess process = token.getProcessInstance();
                ContextInstance c = process.getContextInstance();
                c.setTransientVariable(name, (Object)value);
                c.setTransientVariable("_resource_" + token.getId(), (Object)e.getResource());
                this.getProcessManagerService().dequeue(token);
            } else {
                logger.warn((Object)(token + " spurious resource grant"));
            }
        } else if (event instanceof ResourceRequestRejectedEvent) {
            ResourceRequestRejectedEvent e = (ResourceRequestRejectedEvent)event;
            CustomToken token = (CustomToken)e.getToken();
            if (token.getStatus() == ProcessStatus.QUEUED) {
                logger.warn((Object)(token + " failed due to mismatching protection keys"));
                token.fail();
            } else {
                logger.warn((Object)(token + " - resource request was rejected"));
            }
        } else if (event instanceof QueueOrderChangedEvent) {
            QueueOrderChangedEvent e = (QueueOrderChangedEvent)event;
            CustomToken token = e.getToken();
            WorkflowProcess process = token.getProcessInstance();
            ProcessPriority priority = e.getPriority();
            logger.debug((Object)(token + ", event QUEUE REORDER " + priority));
            if (process.getPriority().equals((Object)priority)) {
                return;
            }
            process.setPriority(priority);
            if (token.isTrace()) {
                this.save(process);
            }
            for (CustomToken t : process.findAllTokens()) {
                if (t.equals((Object)token)) continue;
                DefaultMediator.getInstance().sendAsync((WorkflowEvent)new WorkflowProcessEvent((Object)this, process, (Token)t, WorkflowProcessEventType.PRIORITY_CHANGED));
            }
        } else if (event instanceof ResourceFailedEvent) {
            ResourceFailedEvent e = (ResourceFailedEvent)event;
            CustomToken token = (CustomToken)e.getToken();
            logger.debug((Object)(token + " event RESOURCE FAILURE (" + token.getNode().getName() + ")"));
            ContextInstance c = token.getProcessInstance().getContextInstance();
            c.deleteTransientVariable("_resource_" + token.getId());
            if (e.isHeartBeatFailure()) {
                token.setResumeAfterFail(true);
            } else {
                int count = token.getRetryCount();
                if (count < this.maxRetryAttempts) {
                    token.incrementRetryCount();
                    token.setResumeAfterFail(true);
                } else {
                    logger.info((Object)(token + " exceeded " + this.maxRetryAttempts + " retry attempts"));
                    token.resetRetryCount();
                }
            }
            token.abort();
        } else if (event instanceof ResourceAllocationFailedEvent) {
            ResourceAllocationFailedEvent e = (ResourceAllocationFailedEvent)event;
            DefaultMediator.getInstance().sendAsync((WorkflowEvent)new MessageRejectedEvent((Object)this, e.getToken(), e.getMessage()));
        }
    }

    static {
        logger = Logger.getLogger(EngineDriver.class);
    }
}

