/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log.hibernate;

import com.tandbergtv.workflow.log.IWorkflowMessageLogDAO;
import com.tandbergtv.workflow.log.entities.WorkflowMessageLog;
import com.tandbergtv.workflow.util.SortingOrder;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class WorkflowMessageLogHDAO
implements IWorkflowMessageLogDAO {
    private static final Logger logger = Logger.getLogger(WorkflowMessageLogHDAO.class);
    private Session session;

    public WorkflowMessageLogHDAO(Session session) {
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkflowMessageLog> findByJBPMNodeLogID(long jbpmNodeLogID, int numRecords, int startingRecordNum, String sortColumn, SortingOrder sortOrder) {
        try {
            logger.debug((Object)("Retrieving the message logs associated with jbpmNodeLog - ID: " + jbpmNodeLogID));
            String sortOrderStr = sortOrder == SortingOrder.ASCENDING ? "asc" : "desc";
            String query = this.buildFindByJBPMNodeLogIDQuery(jbpmNodeLogID, false) + " order by " + sortColumn + " " + sortOrderStr;
            Query q = this.session.createQuery(query).setMaxResults(numRecords).setFirstResult(startingRecordNum);
            List list = q.list();
            return list;
        }
        catch (Exception ex) {
            logger.error((Object)("Could not get message logs associated with jbpmNodeLog - ID: " + jbpmNodeLogID), (Throwable)ex);
        }
        finally {
            this.session.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int countByJBPMNodeLogID(long jbpmNodeLogID) {
        try {
            logger.debug((Object)("Finding the count of message logs associated with nodelog - jbpmNodeLogID: " + jbpmNodeLogID));
            String query = this.buildFindByJBPMNodeLogIDQuery(jbpmNodeLogID, true);
            Query q = this.session.createQuery(query);
            int n = ((Long)q.uniqueResult()).intValue();
            return n;
        }
        catch (Exception ex) {
            logger.error((Object)("Could not get count of message logs associated with nodelog - jbpmNodeLogID: " + jbpmNodeLogID), (Throwable)ex);
        }
        finally {
            this.session.close();
        }
        return -1;
    }

    private String buildFindByJBPMNodeLogIDQuery(long jbpmNodeLogID, boolean count) {
        String query = count ? "select count(*) " : "select m ";
        query = query + "from WorkflowMessageLog m where m.nodeLog.id = (select max(wnl.id) from WorkflowNodeLog wnl, NodeLog jnl where wnl.token = jnl.token and wnl.node = jnl.node and wnl.id < jnl.id and jnl.id = " + jbpmNodeLogID + ")";
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int countByWorkflowNodeLogID(long workflowNodeLogID) {
        try {
            logger.debug((Object)("Retrieving the message logs for workflowNodeLogID: " + workflowNodeLogID));
            Criteria criteria = this.session.createCriteria(WorkflowMessageLog.class).add((Criterion)Restrictions.eq((String)"nodeLog.id", (Object)workflowNodeLogID)).setProjection(Projections.rowCount());
            int n = (Integer)criteria.uniqueResult();
            return n;
        }
        catch (Exception ex) {
            logger.error((Object)("Could not load the messages for workflowNodeLogID: " + workflowNodeLogID), (Throwable)ex);
        }
        finally {
            this.session.close();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkflowMessageLog> findByWorkflowNodeLogID(long workflowNodeLogID, int numRecords, int startingRecordNum, String sortColumn, SortingOrder sortOrder) {
        try {
            logger.debug((Object)("Retrieving the message logs for workflowNodeLogID: " + workflowNodeLogID));
            Order order = sortOrder == SortingOrder.ASCENDING ? Order.asc((String)sortColumn) : Order.desc((String)sortColumn);
            Criteria criteria = this.session.createCriteria(WorkflowMessageLog.class).add((Criterion)Restrictions.eq((String)"nodeLog.id", (Object)workflowNodeLogID)).setMaxResults(numRecords).setFirstResult(startingRecordNum).addOrder(order);
            List list = criteria.list();
            return list;
        }
        catch (Exception ex) {
            logger.error((Object)("Could not load the messages for workflowNodeLogID: " + workflowNodeLogID), (Throwable)ex);
        }
        finally {
            this.session.close();
        }
        return null;
    }
}

