/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template.watch;

import com.tandbergtv.workflow.core.ResourceGroupAware;
import com.tandbergtv.workflow.dao.hibernate.HibernateUtil;
import com.tandbergtv.workflow.driver.template.ExtendedJpdlXmlReader;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import java.io.InputStream;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.hibernate.Criteria;
import org.hibernate.classic.Session;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.NodeCollection;

public class WFSJpdlXmlReader
extends ExtendedJpdlXmlReader {
    private static final long serialVersionUID = 582032965130984683L;
    private static final Logger logger = Logger.getLogger(WFSJpdlXmlReader.class);

    public WFSJpdlXmlReader(InputStream stream) {
        super(stream);
    }

    public void readNode(Element nodeElement, Node node, NodeCollection nodeCollection) {
        super.readNode(nodeElement, node, nodeCollection);
        logger.debug((Object)("Read node " + node.getName()));
        Element child = nodeElement.element("resource-group");
        if (child != null) {
            this.readResourceGroup(child, node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readResourceGroup(Element element, Node node) {
        List groups;
        if (!(node instanceof ResourceGroupAware)) {
            return;
        }
        String name = element.attributeValue("name");
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(ResourceGroup.class);
            groups = criteria.list();
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        long id = -1L;
        for (ResourceGroup group : groups) {
            if (!group.getName().equalsIgnoreCase(name)) continue;
            id = group.getId();
            logger.debug((Object)("Found resource group " + id + " for " + name));
            if (!(node instanceof ResourceGroupAware)) break;
            ((ResourceGroupAware)node).setResourceGroupID(Long.valueOf(id));
            break;
        }
        if (id == -1L) {
            this.addError("Failed to find resource group " + name);
        }
    }
}

