/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.exe.resource;

import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.resourcemanager.event.ReleaseResourceEvent;
import org.apache.log4j.Logger;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;

public class ReleaseResource
implements ActionHandler {
    private static final String ALLOCATED_RESOURCE = "_allocated_resource_";
    private static final Logger logger = Logger.getLogger(ReleaseResource.class);
    private static final long serialVersionUID = 2457819245589204128L;

    public void execute(ExecutionContext ec) throws Exception {
        Token token = ec.getToken();
        ContextInstance c = token.getProcessInstance().getContextInstance();
        Node node = ec.getTransitionSource();
        if (node == null) {
            node = token.getNode();
        }
        this.clearResourceAllocationKey(ec);
        String name = "_resource_" + token.getId();
        if (c.hasTransientVariable(name)) {
            logger.info((Object)(token + " node (" + node.getName() + ") releasing resource"));
            DefaultMediator.getInstance().sendAsync((WorkflowEvent)new ReleaseResourceEvent((Object)this, token, node));
            c.deleteTransientVariable(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearResourceAllocationKey(ExecutionContext ec) {
        String defaultVariableName = "_resource_host";
        String variableName = defaultVariableName + "_" + ec.getToken().getId();
        WorkflowProcess process = (WorkflowProcess)ec.getProcessInstance();
        String name = ALLOCATED_RESOURCE + ec.getToken().getId();
        process.lock();
        try {
            String value = (String)process.getContextInstance().getTransientVariable(name);
            if (value != null) {
                ec.setVariable(name, (Object)value);
                process.getContextInstance().deleteTransientVariable(name);
            }
            if (ec.getVariable(variableName) != null) {
                ec.setVariable(variableName, null);
            }
            if (ec.getVariable(defaultVariableName) != null) {
                ec.setVariable(defaultVariableName, null);
            }
        }
        finally {
            process.unlock();
        }
    }
}

