/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.command;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.command.BaseTokenCommand;
import com.tandbergtv.workflow.driver.command.locate.TokenLocatorException;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.io.Serializable;
import org.jbpm.graph.exe.Token;

public class GetStatusCommand
extends BaseTokenCommand {
    private static final long serialVersionUID = 7512142861920499159L;

    public GetStatusCommand(WorkflowMessage message) {
        super(message);
    }

    @Override
    protected WorkflowMessage executeImpl(Token token) {
        WorkflowMessage ack = this.createSuccessResponse();
        ProcessStatus status = ((CustomToken)CustomToken.class.cast(token)).getStatus();
        ack.getPayload().putValue("Status", status.name());
        return ack;
    }

    @Override
    protected Token getToken() throws TokenLocatorException {
        long tokenId = Long.parseLong(this.message.getKey().toString());
        CustomToken token = this.getService().getToken((Serializable)Long.valueOf(tokenId));
        if (token == null) {
            throw new TokenLocatorException("Invalid request key " + tokenId);
        }
        return token;
    }

    protected IPersistenceService getService() {
        return (IPersistenceService)ServiceRegistry.getDefault().lookup(IPersistenceService.class);
    }
}

