/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.ejb;

import com.tandbergtv.neptune.authorization.entity.BasicModule;
import com.tandbergtv.neptune.authorization.entity.BasicPermission;
import com.tandbergtv.neptune.authorization.entity.IModule;
import com.tandbergtv.neptune.authorization.service.IModuleProvider;
import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.workflow.auth.AuthorizationConfReader;
import com.tandbergtv.workflow.auth.Module;
import com.tandbergtv.workflow.auth.Permission;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

public class WorkflowModuleProvider
implements IModuleProvider {
    private static final String AUTH_FILE_NAME = "auth.xml";
    private static final String WORKFLOW_FOLDER_NAME = "workflow";

    public Collection<IModule> getModules() {
        ArrayList<IModule> modules = new ArrayList<IModule>();
        IConfigurationService configReaderService = (IConfigurationService)InjectionUtil.injectInstance((String)"cms/ConfigurationService/local", IConfigurationService.class);
        File authFile = configReaderService.getFile(WORKFLOW_FOLDER_NAME, AUTH_FILE_NAME);
        Set workflowModules = AuthorizationConfReader.getInstance().read(authFile);
        for (Module module : workflowModules) {
            String moduleName = module.getName();
            BasicModule userModule = new BasicModule(moduleName, moduleName);
            Collection authPermissions = module.getPermissions();
            for (Permission authPerm : authPermissions) {
                userModule.getPermissions().add(new BasicPermission(authPerm.getName(), authPerm.getName(), moduleName));
            }
            modules.add((IModule)userModule);
        }
        return modules;
    }
}

