/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.messageprocessor;

import com.tandbergtv.watchpoint.boot.Platform;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.command.AbstractCommand;
import com.tandbergtv.workflow.message.command.CommandException;
import com.tandbergtv.workflow.message.command.ICommand;
import java.lang.reflect.Constructor;
import org.apache.log4j.Logger;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.PluginDescriptor;

public class CommandManager {
    private static Logger logger = Logger.getLogger(CommandManager.class);
    private static final String PLUGIN_ID = "com.tandbergtv.workflow.message";

    public static WorkflowMessage createAndExecute(WorkflowMessage message) {
        WorkflowMessage response = null;
        ICommand cmd = CommandManager.getCommand(message);
        try {
            logger.debug((Object)("Executing command : " + cmd.getClass().getSimpleName()));
            response = CommandManager.getDecoratedCommand(cmd).execute();
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommandException("Error executing command for message " + message.getMessageUID(), e);
        }
        return response;
    }

    public static ICommand getCommand(WorkflowMessage message) {
        ICommand cmd = null;
        WPCLCommand command = WPCLCommand.NULL;
        if (message.getCommand() != null) {
            command = message.getCommand();
        }
        try {
            Extension extension = CommandManager.getCommandExtension(command.getName());
            cmd = CommandManager.createCommand(extension, message);
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommandException("Could not get command for message " + message.getMessageUID(), e);
        }
        return cmd;
    }

    private static ICommand createCommand(Extension extension, WorkflowMessage message) throws Exception {
        Extension.Parameter parameter;
        String className = extension.getParameter("class").valueAsString();
        PluginDescriptor desc = extension.getDeclaringPluginDescriptor();
        PluginManager pm = Platform.getPlatform().getPluginManager();
        Class clazz = pm.getPluginClassLoader(desc).loadClass(className);
        Constructor ctor = clazz.getConstructor(WorkflowMessage.class);
        ICommand command = (ICommand)ctor.newInstance(message);
        if (command instanceof AbstractCommand && (parameter = extension.getParameter("throttle")) != null) {
            ((AbstractCommand)AbstractCommand.class.cast(command)).setThrottle(parameter.valueAsBoolean());
        }
        return command;
    }

    private static ICommand getDecoratedCommand(ICommand decoratee) throws Exception {
        Extension extension = CommandManager.getCommandExtension("decorator");
        if (extension == null) {
            return decoratee;
        }
        String className = extension.getParameter("class").valueAsString();
        PluginDescriptor desc = extension.getDeclaringPluginDescriptor();
        PluginManager pm = Platform.getPlatform().getPluginManager();
        Class clazz = pm.getPluginClassLoader(desc).loadClass(className);
        Constructor ctor = clazz.getConstructor(ICommand.class);
        return (ICommand)ctor.newInstance(decoratee);
    }

    private static Extension getCommandExtension(String name) {
        PluginManager pm = Platform.getPlatform().getPluginManager();
        ExtensionPoint point = pm.getRegistry().getExtensionPoint(PLUGIN_ID, "command");
        for (Extension extension : point.getAvailableExtensions()) {
            Extension.Parameter param = extension.getParameter("alias");
            if (!name.equalsIgnoreCase(param.valueAsString())) continue;
            return extension;
        }
        throw new CommandException("Command not found: " + name);
    }
}

