/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.auth.boot;

import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.workflow.auth.AuthorizationManager;
import com.tandbergtv.workflow.auth.CredentialsManager;
import com.tandbergtv.workflow.auth.IAuthorizationManager;
import com.tandbergtv.workflow.auth.ICredentialsManager;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.dao.hibernate.HibernateUtil;
import java.io.File;
import java.util.ArrayList;
import org.hibernate.SessionFactory;

public class Activator {
    private static final String AUTH_FILE_NAME = "auth.xml";
    private static final String WORKFLOW_FOLDER_NAME = "workflow";
    private static final String CREDENTIALS_MANAGER_NAME = "WORKFLOW_CREDENTIALS_MANAGER";

    public void start() {
        SessionFactory factory = HibernateUtil.getSessionFactory();
        IConfigurationService configReaderService = (IConfigurationService)ServiceRegistry.getDefault().lookup("Configuration Admin");
        AuthorizationManager service = new AuthorizationManager(factory);
        ServiceRegistry.getDefault().register(service.getServiceName(), (Service)service);
        service.start();
        ArrayList<File> authFiles = new ArrayList<File>();
        authFiles.add(configReaderService.getFile(WORKFLOW_FOLDER_NAME, AUTH_FILE_NAME));
        CredentialsManager credentialsManager = new CredentialsManager(authFiles, CREDENTIALS_MANAGER_NAME);
        ServiceRegistry.getDefault().register(credentialsManager.getServiceName(), (Service)credentialsManager);
        credentialsManager.start();
    }

    public void stop() {
        IAuthorizationManager service;
        ICredentialsManager credentialsManager = (ICredentialsManager)ServiceRegistry.getDefault().lookup(CREDENTIALS_MANAGER_NAME);
        if (credentialsManager != null) {
            credentialsManager.stop();
        }
        if ((service = (IAuthorizationManager)ServiceRegistry.getDefault().lookup(IAuthorizationManager.class)) != null) {
            service.stop();
        }
    }
}

