/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.sanmanager.internal;

import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.comm.routing.CommunicationException;
import com.tandbergtv.workflow.comm.routing.IRoutingService;
import com.tandbergtv.workflow.comm.routing.RoutingServiceFactory;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.message.WorkflowPayload;
import com.tandbergtv.workflow.sanmanager.SANManagement;
import com.tandbergtv.workflow.sanmanager.SANManagementException;
import com.tandbergtv.workflow.sanmanager.dto.ISANFile;
import com.tandbergtv.workflow.sanmanager.dto.SANFile;
import com.tandbergtv.workflow.sanmanager.dto.SANFolder;
import com.tandbergtv.workflow.sanmanager.entities.DriveStatus;
import com.tandbergtv.workflow.sanmanager.entities.SANDrive;
import com.tandbergtv.workflow.sanmanager.entities.SANDriveHistory;
import com.tandbergtv.workflow.sanmanager.hibernate.DriveHDAO;
import com.tandbergtv.workflow.sanmanager.hibernate.DriveHistoryHDAO;
import com.tandbergtv.workflow.sanmanager.internal.XMLObjectSerializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;

public class SANManager
implements SANManagement {
    private static final String DRIVE_FREE_SPACE_MESSAGE_UID = "010706";
    private static final String FILE_LIST_MESSAGE_UID = "010709";
    private static final String FOLDER_LIST_MESSAGE_UID = "010710";
    private static final String FOLDER_PATH_PARAM = "Path";
    private static final String DRIVE_FREE_SPACE = "FreeSpace";
    private static final String FOLDER_LIST_RESULT_PARAM = "Result";
    private static final String OUTPUT_ERROR_MESSAGE = "error-message";
    private static final String OUTPUT_ERROR_STACK = "error-stack";
    private static final Logger logger = Logger.getLogger(SANManager.class);
    private Map<Long, SANDrive> driveMap = new HashMap<Long, SANDrive>();
    private ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture future = null;
    private boolean initialized = false;
    private SessionFactory factory;
    private IDestination destination;
    private long delay;
    private static final long INVALID_USED_SPACE = -1L;

    public SANManager(SessionFactory factory, IDestination destination, long delay) {
        this.factory = factory;
        this.destination = destination;
        this.delay = delay;
    }

    public String getServiceName() {
        return "IO Manager";
    }

    public SessionFactory getSessionFactory() {
        return this.factory;
    }

    public void start() {
        if (this.initialized) {
            return;
        }
        this.cacheSANDrives();
        DriveUpdateCommand command = new DriveUpdateCommand();
        this.future = this.executorService.scheduleWithFixedDelay(command, 0L, this.delay, TimeUnit.SECONDS);
        this.initialized = true;
        logger.info((Object)"Successfully initialized the SAN Manager.");
    }

    private void cacheSANDrives() {
        List driveList = null;
        Session session = this.getCurrentSession();
        try {
            session.beginTransaction();
            DriveHDAO driveHDAO = new DriveHDAO(session);
            driveList = driveHDAO.findAll();
            session.getTransaction().commit();
        }
        catch (RuntimeException ex) {
            this.rollbackTransaction(session.getTransaction());
            throw ex;
        }
        for (SANDrive drive : driveList) {
            drive.setUsedSpace(-1L);
            drive.setStatus(DriveStatus.ERROR);
            this.driveMap.put(drive.getId(), drive);
        }
    }

    @Override
    public synchronized List<SANDrive> getAllSANDrives() {
        ArrayList<SANDrive> result = new ArrayList<SANDrive>();
        ArrayList<Long> keys = new ArrayList<Long>(this.driveMap.keySet());
        Collections.sort(keys);
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            long driveId = (Long)iterator.next();
            result.add(this.getDriveCopy(driveId));
        }
        return result;
    }

    @Override
    public synchronized SANDrive getSANDrive(String name) throws SANManagementException {
        for (SANDrive drive : this.driveMap.values()) {
            if (!drive.getName().equals(name)) continue;
            return this.getDriveCopy(drive.getId());
        }
        String msg = "Cannot find drive with Name=" + name + ", no such Drive exists.";
        throw new SANManagementException(msg);
    }

    @Override
    public synchronized SANDrive getSANDrive(long driveId) throws SANManagementException {
        Long key = new Long(driveId);
        if (!this.driveMap.containsKey(key)) {
            String msg = "Cannot find drive with Id=" + driveId + ", no such Drive exists.";
            throw new SANManagementException(msg);
        }
        return this.getDriveCopy(driveId);
    }

    @Override
    public synchronized int getSANDriveCount() {
        return this.driveMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        SANManager sANManager = this;
        synchronized (sANManager) {
            if (!this.initialized) {
                return;
            }
            if (this.future != null) {
                this.future.cancel(false);
            }
            this.executorService.shutdownNow();
            this.driveMap.clear();
            this.initialized = false;
        }
        try {
            boolean completed = this.executorService.awaitTermination(15L, TimeUnit.SECONDS);
            if (!completed) {
                logger.warn((Object)"The SAN Manager Executor Service has not terminated.");
            }
        }
        catch (InterruptedException ie) {
            logger.warn((Object)"Interrupted when waiting for the SAN Executor to terminate.", (Throwable)ie);
        }
        logger.info((Object)"Finished shutting down the SAN Manager.");
    }

    @Override
    public List<SANFile> getFileListing(String sanFolderPath) throws SANManagementException {
        return this.getFileList(sanFolderPath, true);
    }

    @Override
    public List<SANFolder> getFolderListing(String sanFolderPath) throws SANManagementException {
        return this.getFileList(sanFolderPath, false);
    }

    private void storeDriveTrendData(long driveId) {
        SANDrive cachedDrive = this.driveMap.get(driveId);
        if (cachedDrive.getUsedSpace() == -1L) {
            return;
        }
        Session session = this.getCurrentSession();
        try {
            session.beginTransaction();
            SANDriveHistory driveHistory = this.prepareDriveHistoryDO(driveId);
            DriveHDAO driveDAO = new DriveHDAO(session);
            DriveHistoryHDAO driveHistoryDAO = new DriveHistoryHDAO(session);
            driveDAO.update(cachedDrive);
            driveHistoryDAO.update(driveHistory);
            session.getTransaction().commit();
        }
        catch (RuntimeException ex) {
            this.rollbackTransaction(session.getTransaction());
            logger.error((Object)("Error saving SAN Drive[" + cachedDrive.getId() + " ]: " + cachedDrive.getName() + " and store trend data."), (Throwable)ex);
        }
    }

    private SANDriveHistory prepareDriveHistoryDO(long driveID) {
        SANDrive drive = this.driveMap.get(driveID);
        SANDriveHistory driveHistory = new SANDriveHistory();
        driveHistory.setSanDriveID(driveID);
        driveHistory.setSampleDate(drive.getSampleDate());
        driveHistory.setStatus(drive.getStatus());
        driveHistory.setCapacity(drive.getCapacity());
        driveHistory.setUsedBytes(drive.getUsedSpace());
        driveHistory.setWarningThresholdPercent(drive.getWarningThreshold());
        driveHistory.setErrorThresholdPercent(drive.getErrorThreshold());
        return driveHistory;
    }

    private List<? extends ISANFile> getFileList(String path, boolean filesOnly) throws SANManagementException {
        ArrayList<SANFile> sanFileList;
        block8: {
            WorkflowMessage message = this.createFileListMessage(path, filesOnly);
            List<IDestination> destinations = this.createFileSubsystemDestination();
            sanFileList = null;
            try {
                IRoutingService service = RoutingServiceFactory.newInstance().createRoutingService();
                WorkflowMessage response = service.send(message, destinations);
                if (WorkflowMessage.MessageType.ack == response.getType()) {
                    WorkflowPayload payload = response.getPayload();
                    String result = payload.getValue(FOLDER_LIST_RESULT_PARAM);
                    Object list = XMLObjectSerializer.deserializeObject(result);
                    if (filesOnly) {
                        ArrayList<SANFile> fileList = new ArrayList<SANFile>();
                        for (Object obj : (List)list) {
                            fileList.add((SANFile)obj);
                        }
                        sanFileList = fileList;
                    } else {
                        ArrayList<SANFolder> folderList = new ArrayList<SANFolder>();
                        for (Object obj : (List)list) {
                            folderList.add((SANFolder)obj);
                        }
                        sanFileList = folderList;
                    }
                    break block8;
                }
                WorkflowPayload payload = response.getPayload();
                String errorMessage = payload.getValue(OUTPUT_ERROR_MESSAGE);
                String errorStack = payload.getValue(OUTPUT_ERROR_STACK);
                logger.debug((Object)("Failed to get the Folder Listing for Path: " + path + ", " + "Error Stack: " + errorStack));
                String msg = "Failed to get the Folder Listing for Path: " + path + ", Error: " + errorMessage;
                throw new SANManagementException(msg);
            }
            catch (SANManagementException sme) {
                throw sme;
            }
            catch (Exception ex) {
                String msg = "Failed to get the Folder Listing for Path: " + path;
                throw new SANManagementException(msg, ex);
            }
        }
        return sanFileList;
    }

    private WorkflowMessage createFileListMessage(String path, boolean filesOnly) {
        String uidValue = filesOnly ? FILE_LIST_MESSAGE_UID : FOLDER_LIST_MESSAGE_UID;
        WorkflowMessage message = WorkflowMessageFactory.createControlMessage((String)uidValue);
        message.putValue(FOLDER_PATH_PARAM, path);
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDrive(SANDrive drive) {
        long capacity = this.getTotalSpace(drive);
        long free = this.getFreeSpace(drive);
        SANManager sANManager = this;
        synchronized (sANManager) {
            this.updateDriveProperties(drive.getId(), free, capacity);
            this.storeDriveTrendData(drive.getId());
        }
    }

    private void updateDriveProperties(long driveId, long free, long capacity) {
        SANDrive cachedDrive = this.driveMap.get(driveId);
        if (cachedDrive == null) {
            logger.warn((Object)("Cannot update SAN Drive properties for Drive: " + driveId + ", no such drive exists."));
            return;
        }
        DriveStatus previous = cachedDrive.getStatus();
        DriveStatus status = DriveStatus.OK;
        if (free < 0L || capacity < 0L) {
            status = DriveStatus.ERROR;
            cachedDrive.setStatus(status);
            cachedDrive.setUsedSpace(-1L);
            if (previous != status) {
                logger.warn((Object)(String.valueOf(cachedDrive.getName()) + ", drive status " + (Object)((Object)status)));
            }
        } else {
            cachedDrive.setCapacity(capacity);
            long previousused = cachedDrive.getUsedSpace();
            long used = capacity >= free ? capacity - free : 0L;
            cachedDrive.setUsedSpace(used);
            double usedPercentage = capacity > 0L ? (double)used / (double)capacity * 100.0 : 100.0;
            logger.debug((Object)("The Used Percentage for the Drive: " + usedPercentage));
            if (usedPercentage >= (double)cachedDrive.getErrorThreshold()) {
                status = DriveStatus.ERROR;
            } else if (usedPercentage >= (double)cachedDrive.getWarningThreshold()) {
                status = DriveStatus.WARNING;
            }
            cachedDrive.setStatus(status);
            if (status.ordinal() >= DriveStatus.WARNING.ordinal() && (previousused == -1L || previous != status)) {
                logger.warn((Object)(String.valueOf(cachedDrive.getName()) + ", drive status " + (Object)((Object)status)));
            }
            logger.info((Object)("[Storage] Drive " + cachedDrive.getName() + " is " + usedPercentage + "% used, path " + cachedDrive.getPath()));
        }
        cachedDrive.setSampleDate(new Date());
    }

    private long getTotalSpace(SANDrive drive) {
        long capacity = 0L;
        WorkflowMessage request = WorkflowMessageFactory.createControlMessage((String)"010731");
        request.putValue(FOLDER_PATH_PARAM, drive.getPath());
        try {
            WorkflowMessage response = this.send(request);
            String result = response.getValue("Size");
            capacity = Long.parseLong(result);
        }
        catch (SANManagementException e) {
            logger.error((Object)("[Storage] Failed to get the capacity of Drive: " + drive.getName() + ", path " + drive.getPath() + ": " + e.getMessage()), (Throwable)e);
        }
        return capacity;
    }

    private long getFreeSpace(SANDrive drive) {
        WorkflowMessage message = this.createFolderSizeMessage(drive);
        List<IDestination> destinations = this.createFileSubsystemDestination();
        long free = -1L;
        try {
            IRoutingService service = RoutingServiceFactory.newInstance().createRoutingService();
            WorkflowMessage response = service.send(message, destinations);
            WorkflowPayload payload = response.getPayload();
            if (WorkflowMessage.MessageType.ack == response.getType()) {
                String result = payload.getValue(DRIVE_FREE_SPACE);
                free = Long.parseLong(result);
            } else {
                String errorMessage = payload.getValue(OUTPUT_ERROR_MESSAGE);
                String errorStack = payload.getValue(OUTPUT_ERROR_STACK);
                logger.error((Object)("[Storage] Failed to get the Folder Size for Drive: " + drive.getName() + ", path " + drive.getPath() + ": " + errorMessage));
                logger.debug((Object)("The Error Stack when getting Folder Size: " + errorStack));
            }
        }
        catch (Exception ex) {
            logger.error((Object)("[Storage] Failed to get the Folder Size for Drive: " + drive.getName() + ", path " + drive.getPath()), (Throwable)ex);
        }
        return free;
    }

    private WorkflowMessage createFolderSizeMessage(SANDrive drive) {
        WorkflowMessage message = WorkflowMessageFactory.createControlMessage((String)DRIVE_FREE_SPACE_MESSAGE_UID);
        String folderPath = drive.getPath();
        message.putValue(FOLDER_PATH_PARAM, folderPath);
        return message;
    }

    private WorkflowMessage send(WorkflowMessage request) throws SANManagementException {
        WorkflowMessage response;
        List<IDestination> destinations = this.createFileSubsystemDestination();
        IRoutingService service = RoutingServiceFactory.newInstance().createRoutingService();
        try {
            response = service.send(request, destinations);
            if (response.getType() == WorkflowMessage.MessageType.nack) {
                String message = response.getValue(OUTPUT_ERROR_MESSAGE);
                throw new SANManagementException(message);
            }
        }
        catch (CommunicationException e) {
            throw new SANManagementException(e);
        }
        return response;
    }

    private List<IDestination> createFileSubsystemDestination() {
        ArrayList<IDestination> destinations = new ArrayList<IDestination>();
        destinations.add(this.destination);
        return destinations;
    }

    private SANDrive getDriveCopy(long driveId) {
        SANDrive drive = this.driveMap.get(driveId);
        if (drive != null) {
            drive = (SANDrive)drive.clone();
        }
        return drive;
    }

    private Session getCurrentSession() {
        return this.factory.getCurrentSession();
    }

    private void rollbackTransaction(Transaction transaction) {
        try {
            transaction.rollback();
        }
        catch (RuntimeException ex) {
            logger.error((Object)"Failed to roll back the transaction.", (Throwable)ex);
        }
    }

    private class DriveUpdateCommand
    implements Runnable {
        private DriveUpdateCommand() {
        }

        @Override
        public void run() {
            logger.debug((Object)"Starting the Drive Update Thread to update all the Drive Properties.");
            try {
                List<SANDrive> driveList = SANManager.this.getAllSANDrives();
                for (SANDrive drive : driveList) {
                    try {
                        logger.debug((Object)("Updating properties for Drive[" + drive.getId() + "]: " + drive.getPath()));
                        SANManager.this.updateDrive(drive);
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Failed to store trend data and update SAN Drive[" + drive.getId() + "]: " + drive.getPath()), (Throwable)ex);
                    }
                }
            }
            catch (Exception ex) {
                String msg = "Thread to update the Drive Configuration caught unexpected error.";
                logger.error((Object)msg, (Throwable)ex);
            }
            logger.debug((Object)"Finished the Drive Update Thread to update all the Drive Properties.");
        }

        private void testFileListing(SANDrive drive) {
            try {
                List<SANFile> sanFiles = SANManager.this.getFileListing(drive.getPath());
                StringBuilder builder = new StringBuilder();
                builder.append("\n");
                builder.append("File listing[" + sanFiles.size() + "] for folder: " + drive.getPath());
                builder.append("\n");
                for (SANFile file : sanFiles) {
                    builder.append("\tFile: " + file.getName());
                    builder.append(", Path: " + file.getAbsolutePath());
                    builder.append(", LMD: " + file.getLastModified());
                    builder.append(", Size: " + file.getLength());
                    builder.append("\n");
                }
                builder.append("\n");
                List<SANFolder> sanFolders = SANManager.this.getFolderListing(drive.getPath());
                builder.append("Folder listing[" + sanFolders.size() + "] for folder: " + drive.getPath());
                builder.append("\n");
                for (SANFolder file : sanFolders) {
                    builder.append("\tFile: " + file.getName());
                    builder.append(", Path: " + file.getAbsolutePath());
                    builder.append(", LMD: " + file.getLastModified());
                    builder.append(", Child Folder Count: " + file.getChildFolderCount());
                    builder.append("\n");
                }
                builder.append("\n");
                builder.append("\n");
                logger.debug((Object)("SAN Stats: " + builder.toString()));
            }
            catch (Exception ex) {
                String msg = "Thread to update the Drive Configuration caught unexpected error.";
                logger.error((Object)msg, (Throwable)ex);
            }
        }
    }
}

