/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.timer;

import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.driver.timer.ITimerService;
import com.tandbergtv.workflow.driver.timer.TokenTimer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.jbpm.graph.exe.Token;

public class TimerManager
implements ITimerService {
    private ISchedulerService<Void> scheduler = new Scheduler("token-timers", 1, 1);
    private Map<Token, Future<Void>> futures = new HashMap<Token, Future<Void>>();
    private static final String SERVICE_NAME = "token-timers";
    private static final Logger logger = Logger.getLogger(TimerManager.class);
    private static final Lock timerlock = new ReentrantLock();

    @Override
    public void addTimer(TokenTimer timer) {
        long delay = timer.getTimer().getDueDate().getTime() - System.currentTimeMillis();
        timerlock.lock();
        try {
            Future future = this.scheduler.schedule((Callable)timer, delay);
            this.futures.put(timer.getToken(), future);
        }
        finally {
            timerlock.unlock();
        }
        logger.info((Object)(timer.getToken() + " added timer, total " + this.scheduler.count()));
    }

    @Override
    public void deleteTimer(Token token) {
        timerlock.lock();
        try {
            Future<Void> future = this.futures.get(token);
            if (future != null) {
                future.cancel(true);
                this.futures.remove(token);
                this.scheduler.purge();
            }
        }
        finally {
            timerlock.unlock();
        }
        logger.info((Object)(token + " deleted timer, total " + this.scheduler.count()));
    }

    public void start() {
        this.scheduler.start();
    }

    public void stop() {
        this.scheduler.stop();
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }
}

