/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.search;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.driver.search.ListParameter;
import com.tandbergtv.workflow.driver.search.RangeParameter;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.driver.service.ITokenSearchService;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class TokenSearchService
implements ITokenSearchService {
    private SessionFactory factory;
    private static final String SERVICE_NAME = "Token Search Service";

    public TokenSearchService(SessionFactory factory) {
        this.factory = factory;
    }

    @Override
    public int count(SearchCriteria criteria) {
        if (criteria == null) {
            throw new IllegalArgumentException("Search criteria must not be null");
        }
        Session session = null;
        int count = 0;
        try {
            session = this.factory.openSession();
            Criteria c = this.getBasicCountCriteria((org.hibernate.Session)session);
            c = this.addCriteria(criteria, c);
            c = this.addProcessCriteria(criteria, c);
            count = (Integer)c.uniqueResult();
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return count;
    }

    @Override
    public Collection<CustomToken> search(SearchCriteria criteria) {
        if (criteria == null) {
            throw new IllegalArgumentException("Search criteria must not be null");
        }
        Session session = null;
        ArrayList<CustomToken> tokens = new ArrayList();
        try {
            session = this.factory.openSession();
            Criteria c = this.getBasicCriteria((org.hibernate.Session)session);
            c = this.addCriteria(criteria, c);
            c = this.addProcessCriteria(criteria, c);
            tokens = c.list();
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return tokens;
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void start() {
    }

    public void stop() {
    }

    private Criteria getBasicCriteria(org.hibernate.Session session) {
        return session.createCriteria(CustomToken.class);
    }

    private Criteria getBasicCountCriteria(org.hibernate.Session session) {
        return this.getBasicCriteria(session).setProjection(Projections.rowCount());
    }

    private Criteria addCriteria(SearchCriteria criteria, Criteria c) {
        ValueParameter parameter;
        ListParameter list = (ListParameter)criteria.getParameter("tokenstatus", ListParameter.class);
        if (list != null) {
            c.add(Restrictions.in((String)"status", (Collection)list.getValues()));
        }
        if ((parameter = (ValueParameter)criteria.getParameter("child", ValueParameter.class)) != null && Boolean.TRUE.equals(parameter.getValue())) {
            c.add(Restrictions.isNotNull((String)"parent"));
        } else {
            c.add(Restrictions.isNull((String)"parent"));
        }
        return c;
    }

    private Criteria addProcessCriteria(SearchCriteria criteria, Criteria c) {
        ListParameter list;
        c = c.createCriteria("processInstance").add((Criterion)Restrictions.eq((String)"active", (Object)true));
        RangeParameter parameter = (RangeParameter)criteria.getParameter("start", RangeParameter.class);
        if (parameter != null) {
            String from = parameter.getFrom();
            try {
                if (from != null) {
                    c.add((Criterion)Restrictions.gt((String)"start", (Object)new SimpleDateFormat("yyyy-MM-dd").parse(from)));
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if ((list = (ListParameter)criteria.getParameter("status", ListParameter.class)) != null) {
            c.add(Restrictions.in((String)"status", (Collection)list.getValues()));
        }
        return c.createCriteria("processDefinition").add(Restrictions.sqlRestriction((String)"processDefinitionTypeId=2"));
    }
}

