/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.LogLevel;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.Cluster;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.core.service.cache.IDistributedCache;
import com.tandbergtv.workflow.driver.DriverRuntimeException;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import java.io.Serializable;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;

public class HibernatePersistenceService
implements IPersistenceService {
    private ICacheService<WorkflowProcess> cache;
    private SessionFactory factory;
    private static final Logger logger = Logger.getLogger(HibernatePersistenceService.class);
    private static final String SERVICE_NAME = "Process Persistence";

    public HibernatePersistenceService(SessionFactory factory) {
        this.factory = factory;
        this.cache = (ICacheService)ServiceRegistry.getDefault().lookup("Process Cache");
    }

    @Override
    public WorkflowProcess get(Serializable id) {
        WorkflowProcess process = (WorkflowProcess)this.cache.get(id);
        if (process != null) {
            return process;
        }
        Session session = this.getSession();
        try {
            process = (WorkflowProcess)session.load(WorkflowProcess.class, id);
        }
        finally {
            this.closeSession(session);
        }
        return process;
    }

    @Override
    public CustomToken getToken(Serializable id) {
        Session session = this.getSession();
        Query query = session.createQuery("select p.id from WorkflowProcess p, CustomToken t where t.processInstance = p and t.id = ?");
        query.setParameter(0, (Object)id);
        try {
            Number number = (Number)query.uniqueResult();
            if (number != null) {
                long pid = number.longValue();
                CustomToken customToken = this.get(Long.valueOf(pid)).findToken(((Long)id).longValue());
                return customToken;
            }
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    @Override
    public Serializable create(WorkflowProcess process) {
        Session session = this.getSession();
        Transaction t = null;
        try {
            try {
                t = session.beginTransaction();
                session.saveOrUpdate((Object)process);
                CustomToken superProcessToken = process.getSuperProcessToken();
                if (superProcessToken != null) {
                    session.saveOrUpdate((Object)superProcessToken.getProcessInstance());
                }
                if (Cluster.owner((Object)process.getId())) {
                    this.cache.add((Serializable)Long.valueOf(process.getId()), (Object)process);
                } else {
                    this.updateCache(process);
                }
                t.commit();
                if (superProcessToken != null) {
                    this.cache.add((Serializable)Long.valueOf(superProcessToken.getProcessInstance().getId()), (Object)superProcessToken.getProcessInstance());
                    logger.info((Object)("[Process] " + process.getRootToken() + ", template " + process.getProcessDefinition().getFullName() + ", parent " + superProcessToken));
                } else {
                    logger.info((Object)("[Process] " + process.getRootToken() + ", template " + process.getProcessDefinition().getFullName()));
                }
            }
            catch (Exception e) {
                if (t != null) {
                    t.rollback();
                }
                logger.error((Object)("Failed to save the process " + process), (Throwable)e);
                if (process.getId() > 0L) {
                    this.cache.remove((Serializable)Long.valueOf(process.getId()));
                }
                throw new DriverRuntimeException("Failed to save the process", e);
            }
        }
        finally {
            this.closeSession(session);
        }
        return Long.valueOf(process.getId());
    }

    @Override
    public void save(WorkflowProcess process) {
        this.cache.add((Serializable)Long.valueOf(process.getId()), (Object)process);
        if (!this.isTrace(process)) {
            return;
        }
        process.lock();
        try {
            this.doSave(process);
        }
        finally {
            process.unlock();
        }
    }

    @Override
    public void persist(WorkflowProcess process) {
        process.lock();
        try {
            this.doSave(process);
        }
        finally {
            process.unlock();
            if (process.hasEnded() || !process.isActive()) {
                this.cache.remove((Serializable)Long.valueOf(process.getId()));
            } else {
                this.cache.add((Serializable)Long.valueOf(process.getId()), (Object)process);
            }
        }
    }

    @Override
    public void save(CustomToken token) {
        this.save(token.getProcessInstance());
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void start() {
    }

    public void stop() {
    }

    private boolean isTrace(WorkflowProcess process) {
        return process.getLogLevel() == LogLevel.ALL;
    }

    private void updateCache(WorkflowProcess process) {
        ConcurrentMap map = ((IDistributedCache)this.cache).getMap();
        map.put(process.getId(), process);
    }

    private void doSave(WorkflowProcess process) {
        Session session = this.getSession();
        Transaction t = null;
        try {
            try {
                t = session.beginTransaction();
                session.saveOrUpdate((Object)process);
                t.commit();
            }
            catch (Exception e) {
                if (t != null) {
                    t.rollback();
                }
                logger.error((Object)("Failed to save the process " + process), (Throwable)e);
                throw new DriverRuntimeException("Failed to save the process", e);
            }
        }
        finally {
            this.closeSession(session);
        }
    }

    private Session getSession() {
        return this.factory.openSession();
    }

    private void closeSession(Session session) {
        if (session != null) {
            session.close();
        }
    }
}

