/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core;

import com.tandbergtv.workflow.core.AbstractTaskNode;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.jbpm.JbpmConfiguration;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.def.DelegationException;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.instantiation.Delegation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class AutomaticTaskNode
extends AbstractTaskNode {
    private static final String START_TOKEN = "<receive>";
    private static final String END_TOKEN = "</receive>";
    private static final long serialVersionUID = 4614455101092538306L;
    private static final Logger logger = Logger.getLogger(AutomaticTaskNode.class);

    public AutomaticTaskNode() {
    }

    public AutomaticTaskNode(String name) {
        super(name);
    }

    public void execute(ExecutionContext executionContext) {
        CustomToken token;
        block12: {
            token = (CustomToken)executionContext.getToken();
            WorkflowProcess process = token.getProcessInstance();
            logger.info((Object)(token + " (" + this.name + ")"));
            if (this.action != null) {
                try {
                    try {
                        if (this.action.getActionDelegation() != null) {
                            Delegation delegation = (Delegation)JbpmConfiguration.Configs.getObject((String)"jbpm.action.delegation");
                            delegation.setClassName(this.action.getActionDelegation().getClassName());
                            delegation.setConfiguration(this.action.getActionDelegation().getConfiguration());
                            delegation.setConfigType(this.action.getActionDelegation().getConfigType());
                            delegation.setProcessDefinition(this.action.getActionDelegation().getProcessDefinition());
                            ActionHandler handler = (ActionHandler)delegation.instantiate();
                            if (handler == null) {
                                throw new RuntimeException(token + ", cannot instantiate action");
                            }
                            token.setActionHandler(handler);
                            handler.execute(executionContext);
                        } else {
                            this.action.execute(executionContext);
                        }
                    }
                    catch (Throwable t) {
                        try {
                            this.raiseException(t, executionContext);
                        }
                        catch (DelegationException e) {
                            logger.warn((Object)(token + ", no exception handler defined for template - " + process.getProcessDefinition().getName()));
                            token.fail();
                        }
                        token.setActionHandler(null);
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    token.setActionHandler(null);
                    throw throwable;
                }
                token.setActionHandler(null);
            }
        }
        if (token.getStatus() != ProcessStatus.ERROR) {
            super.leave(executionContext);
        }
    }

    public String getMessage() {
        String configuration = this.getConfiguration();
        if (configuration == null) {
            return null;
        }
        int from = configuration.indexOf(START_TOKEN);
        int to = configuration.indexOf(END_TOKEN);
        if (from == -1 || to == -1) {
            return null;
        }
        return configuration.substring(from + START_TOKEN.length(), to).trim();
    }

    public Map<String, String> getCorrelationKeys() {
        HashMap<String, String> keys = new HashMap<String, String>();
        String configuration = this.getConfiguration();
        if (configuration == null) {
            return keys;
        }
        int from = configuration.indexOf("<keys>");
        int to = configuration.indexOf("</keys>");
        if (from == -1 || to == -1) {
            return keys;
        }
        try {
            XPath path = XPathFactory.newInstance().newXPath();
            String tmp = configuration.substring(from, to + 7);
            Node document = this.getNode(tmp);
            NodeList nodes = (NodeList)path.evaluate("//keys/entry", document, XPathConstants.NODESET);
            int i = 0;
            while (i < nodes.getLength()) {
                Node n = nodes.item(i);
                keys.put(n.getFirstChild().getTextContent(), n.getLastChild().getTextContent());
                ++i;
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        return keys;
    }

    private Node getNode(String xml) {
        Document node = null;
        try {
            node = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(xml)));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create valid DOM: " + xml, e);
        }
        return node;
    }

    private String getConfiguration() {
        if (this.action == null) {
            return null;
        }
        Delegation delegation = this.action.getActionDelegation();
        if (delegation == null) {
            return null;
        }
        return delegation.getConfiguration();
    }
}

