/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core;

import com.tandbergtv.workflow.auth.domain.IProtectionKeyAware;
import com.tandbergtv.workflow.auth.domain.ProtectionKey;
import com.tandbergtv.workflow.core.Selector;
import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.graph.DefaultExceptionHandler;
import com.tandbergtv.workflow.core.graph.Graph;
import com.tandbergtv.workflow.core.graph.NodeVisitor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.jbpm.graph.def.DelegationException;
import org.jbpm.graph.def.ExceptionHandler;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.node.StartState;
import org.jbpm.module.def.ModuleDefinition;
import org.jbpm.taskmgmt.def.Task;

public class WorkflowTemplate
extends ProcessDefinition
implements Graph,
IProtectionKeyAware {
    private static final long serialVersionUID = 5496751233335662922L;
    private Set<ProtectionKey> protectionKeys = new HashSet<ProtectionKey>();
    private Set<Selector> selectorKeys = new HashSet<Selector>();
    private Date createDate;

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    @Override
    public Set<ProtectionKey> getProtectionKeys() {
        return this.protectionKeys;
    }

    public void setProtectionKeys(Set<ProtectionKey> protectionKeys) {
        this.protectionKeys = protectionKeys;
    }

    @Override
    public void addProtectionKey(ProtectionKey protectionKey) {
        this.protectionKeys.add(protectionKey);
    }

    public ModuleDefinition addDefinition(ModuleDefinition moduleDefinition) {
        try {
            Field field = ModuleDefinition.class.getDeclaredField("name");
            field.setAccessible(true);
            field.set(moduleDefinition, moduleDefinition.getClass().getName());
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return super.addDefinition(moduleDefinition);
    }

    public String getFullName() {
        return String.valueOf(this.name) + " - v" + this.version;
    }

    public Collection<TaskVariable> getStartTaskVariables() {
        Task task = this.getTaskMgmtDefinition().getStartTask();
        if (task != null) {
            return task.getTaskController().getVariableAccesses();
        }
        return new ArrayList<TaskVariable>();
    }

    @Override
    public void depthFirstTraversal(NodeVisitor visitor) {
        Queue<Node> roots = this.getRoots();
        HashMap<Node, Boolean> traversed = new HashMap<Node, Boolean>();
        for (Node root : roots) {
            this.depthFirstTraversal(root, traversed, visitor);
        }
    }

    private void depthFirstTraversal(Node node, Map<Node, Boolean> traversed, NodeVisitor visitor) {
        traversed.put(node, true);
        visitor.visit(node);
        List transitions = node.getLeavingTransitions();
        if (transitions == null) {
            return;
        }
        for (Transition t : transitions) {
            Node destination = t.getTo();
            Boolean visited = traversed.get(destination);
            if (visited != null && visited.booleanValue()) continue;
            this.depthFirstTraversal(destination, traversed, visitor);
        }
    }

    @Override
    public void breadthFirstTraversal(NodeVisitor visitor) {
        Queue<Node> roots = this.getRoots();
        HashMap<Node, Boolean> traversed = new HashMap<Node, Boolean>();
        LinkedList<Node> queue = new LinkedList<Node>();
        for (Node root : roots) {
            traversed.put(root, true);
            queue.add(root);
            while (queue.size() > 0) {
                Node node = (Node)queue.remove();
                visitor.visit(node);
                List transitions = node.getLeavingTransitions();
                if (transitions == null) {
                    return;
                }
                for (Transition transition : transitions) {
                    Node destination = transition.getTo();
                    Boolean visited = (Boolean)traversed.get(destination);
                    if (visited != null && visited.booleanValue()) continue;
                    traversed.put(destination, true);
                    queue.add(destination);
                }
            }
        }
    }

    @Override
    public Queue<Node> getRoots() {
        LinkedList<Node> roots = new LinkedList<Node>();
        roots.add(this.getStartState());
        for (Node node : this.nodes) {
            Set transitions;
            if (node instanceof StartState || (transitions = node.getArrivingTransitions()) != null && !transitions.isEmpty()) continue;
            roots.add(node);
        }
        return roots;
    }

    public Set<Selector> getSelectorKeys() {
        return this.selectorKeys;
    }

    public void addSelectorKey(Selector selector) {
        selector.setTemplate(this);
        this.selectorKeys.add(selector);
    }

    public void removeSelectorKey(Selector selector) {
        this.selectorKeys.remove(selector);
    }

    public void removeSelectorKeys() {
        this.selectorKeys.clear();
    }

    public void raiseException(Throwable exception, ExecutionContext context) throws DelegationException {
        if (this.exceptionHandlers == null || this.exceptionHandlers.isEmpty()) {
            this.addExceptionHandler(new DefaultExceptionHandler());
        }
        try {
            ExceptionHandler exceptionHandler = this.findExceptionHandler(exception);
            if (exceptionHandler != null) {
                context.setException(exception);
                exceptionHandler.handleException(context);
            }
        }
        catch (Throwable t) {
            throw new DelegationException(t, context);
        }
    }

    public String toString() {
        String string = this.getFullName();
        if (this.getId() != 0L) {
            return "[" + this.getId() + "] " + string;
        }
        return string;
    }
}

