/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.queue;

import com.tandbergtv.workflow.core.queue.IQueueInsertStrategy;
import com.tandbergtv.workflow.core.queue.IQueueOwner;
import com.tandbergtv.workflow.core.queue.IQueueRemoveStrategy;
import com.tandbergtv.workflow.core.queue.Queue;
import com.tandbergtv.workflow.core.queue.QueueItem;
import com.tandbergtv.workflow.core.queue.admit.IAdmissionControl;
import java.util.Collection;

public abstract class AbstractQueue<T>
implements Queue<T> {
    protected IQueueOwner owner;
    protected IQueueInsertStrategy<T> insertstrategy;
    protected IQueueRemoveStrategy<T> removalstrategy;
    protected IAdmissionControl<T> admissioncontrol;

    protected AbstractQueue() {
    }

    protected AbstractQueue(IQueueOwner owner) {
        this.owner = owner;
    }

    protected AbstractQueue(IQueueOwner owner, IAdmissionControl<T> admissioncontrol, IQueueInsertStrategy<T> insertstrategy, IQueueRemoveStrategy<T> removalstrategy) {
        this.owner = owner;
        this.admissioncontrol = admissioncontrol;
        this.insertstrategy = insertstrategy;
        this.removalstrategy = removalstrategy;
    }

    @Override
    public IQueueOwner getOwner() {
        return this.owner;
    }

    public IQueueInsertStrategy getInsertStrategy() {
        return this.insertstrategy;
    }

    public void setInsertStrategy(IQueueInsertStrategy<T> insertstrategy) {
        this.insertstrategy = insertstrategy;
    }

    public IQueueRemoveStrategy getRemovalStrategy() {
        return this.removalstrategy;
    }

    public void setRemovalStrategy(IQueueRemoveStrategy<T> removalstrategy) {
        this.removalstrategy = removalstrategy;
    }

    public IAdmissionControl<T> getAdmissionControlStrategy() {
        return this.admissioncontrol;
    }

    public void setAdmissionControlStrategy(IAdmissionControl<T> strategy) {
        this.admissioncontrol = strategy;
    }

    @Override
    public void insert(QueueItem<T> item) {
        if (!this.admissioncontrol.canAdmit(item)) {
            return;
        }
        this.insertstrategy.insert(item);
    }

    @Override
    public QueueItem<T> remove() {
        return this.removalstrategy.remove();
    }

    protected abstract Collection<QueueItem<T>> getItems();
}

