/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager;

import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.queue.monitor.IQueueMonitor;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.service.IAuthorizationManager;
import com.tandbergtv.workflow.pluginmanager.PluginManagement;
import com.tandbergtv.workflow.pluginmanager.entities.FailureDescriptor;
import com.tandbergtv.workflow.pluginmanager.entities.ManagementDescriptor;
import com.tandbergtv.workflow.pluginmanager.entities.ResourceGroupDescriptor;
import com.tandbergtv.workflow.pluginmanager.entities.ResourceTypeDescriptor;
import com.tandbergtv.workflow.resourcemanager.ResourceContainer;
import com.tandbergtv.workflow.resourcemanager.ResourceGroupContainer;
import com.tandbergtv.workflow.resourcemanager.ResourceGroupQueueSampler;
import com.tandbergtv.workflow.resourcemanager.ResourceManager;
import com.tandbergtv.workflow.resourcemanager.ResourceManagerContext;
import com.tandbergtv.workflow.resourcemanager.WorkerThread;
import com.tandbergtv.workflow.resourcemanager.dataaccess.ResourceDAI;
import com.tandbergtv.workflow.resourcemanager.dataaccess.ResourceGroupDAI;
import com.tandbergtv.workflow.resourcemanager.dataaccess.ResourceTypeDAI;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroupQueueItem;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceState;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceType;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.log4j.Logger;
import org.hibernate.Session;

class ResourceManagerLifeCycleManager {
    private static final Logger logger = Logger.getLogger(ResourceManagerLifeCycleManager.class);
    private static final long THREAD_SHUTDOWN_TIMEOUT = 30000L;
    private static final int THREAD_SHUTDOWN_RETRY = 3;
    private ResourceManagerContext context;
    private boolean isInitialized = false;
    private static final String MBEAN_NAME = "com.tandbergtv.watchpoint:type=Queue,name=Resource Group ";

    ResourceManagerLifeCycleManager(ResourceManagerContext context) {
        this.context = context;
    }

    public void initialize() {
        if (this.isInitialized) {
            return;
        }
        logger.debug((Object)"Initializing the Resource Manager...");
        this.context.mediator = DefaultMediator.getInstance();
        this.context.pluginManager = (PluginManagement)ServiceRegistry.getDefault().lookup(PluginManagement.class);
        this.initializeCache();
        this.initializeResources();
        this.context.mediator.register((IColleague)this.context.manager);
        this.isInitialized = true;
        logger.info((Object)"Successfully initialized the Resource Manager.");
    }

    private void initializeCache() {
        logger.debug((Object)"Initializing the Resource Manager Cache...");
        Session currentSession = this.context.getCurrentSession();
        try {
            currentSession.beginTransaction();
            this.cacheResourceTypes();
            this.cacheResourceGroups();
            this.cacheResources();
            currentSession.getTransaction().commit();
        }
        catch (RuntimeException ex) {
            this.context.rollbackTransaction(currentSession.getTransaction());
            throw ex;
        }
        logger.info((Object)"Successfully initialized the Resource Manager Cache with all active Resources, Groups and Types.");
    }

    private void initializeResources() {
        for (ResourceContainer resContainer : this.context.resources.values()) {
            this.context.stateManager.initializeResource(resContainer);
            this.context.storeResource(resContainer.getResource().getId());
        }
    }

    void initializeResourceGroups() {
        for (ResourceGroupContainer rgContainer : this.context.resourceGroups.values()) {
            ResourceGroup resourceGroup = rgContainer.getResourceGroup();
            for (ResourceGroupQueueItem queueItem : resourceGroup.getQueue()) {
                this.context.queuedTokenLookup.put(queueItem.getTokenId(), resourceGroup.getId());
            }
            rgContainer.start();
        }
    }

    private void cacheResourceTypes() {
        ResourceTypeDAI rtDAI = this.context.daoFactory.getResourceTypeDAO();
        List resourceTypeList = rtDAI.findAll();
        List<ResourceTypeDescriptor> descs = this.context.pluginManager.getResourceTypeDescriptors();
        for (ResourceTypeDescriptor desc : descs) {
            ResourceType resourceType2;
            ResourceType match = null;
            for (ResourceType resourceType2 : resourceTypeList) {
                if (!desc.getSystemId().equals(resourceType2.getSystemId())) continue;
                match = resourceType2;
                break;
            }
            resourceType2 = this.createResourceType(desc, match);
            resourceType2 = match == null ? rtDAI.create(resourceType2) : rtDAI.update(resourceType2);
            this.context.resourceTypes.put(resourceType2.getId(), resourceType2);
        }
        List<ResourceTypeDescriptor> nonLicDescs = this.context.pluginManager.getNonLicensedDescriptors();
        ArrayList<Long> nonLicensedTypeIds = new ArrayList<Long>();
        for (ResourceTypeDescriptor desc : nonLicDescs) {
            ResourceType resourceType3;
            ResourceType match = null;
            for (ResourceType resourceType3 : resourceTypeList) {
                if (!desc.getSystemId().equals(resourceType3.getSystemId())) continue;
                match = resourceType3;
                break;
            }
            resourceType3 = this.createResourceType(desc, match);
            resourceType3 = match == null ? rtDAI.create(resourceType3) : rtDAI.update(resourceType3);
            nonLicensedTypeIds.add(resourceType3.getId());
            this.context.inactiveResourceTypes.put(resourceType3.getId(), resourceType3);
        }
        for (ResourceType resourceType : resourceTypeList) {
            if (this.context.resourceTypes.containsKey(resourceType.getId()) || nonLicensedTypeIds.contains(resourceType.getId())) continue;
            String msg = "The Resource Type: " + resourceType.getSystemId() + " - " + resourceType.getName() + " [" + resourceType.getId() + "] is not defined by a plugin, and is being marked inactive.";
            logger.warn((Object)msg);
            this.context.pluginManager.addMissingResourceTypeDescriptor(resourceType);
            this.context.inactiveResourceTypes.put(resourceType.getId(), resourceType);
        }
    }

    private void cacheResources() {
        ResourceDAI resDAI = this.context.daoFactory.getResourceDAO();
        List<Resource> resourceList = resDAI.findByActive(true);
        int availSystemRes = this.context.systemResourceLimit;
        int availHumanRes = this.context.humanResourceLimit;
        int sysResCount = 0;
        int humanResCount = 0;
        for (Resource resource : resourceList) {
            ResourceState state;
            String systemId = resource.getResourceType().getSystemId();
            ResourceTypeDescriptor desc = this.context.pluginManager.getResourceTypeDescriptor(systemId);
            ResourceTypeDescriptor nonLicDesc = this.context.pluginManager.getNonLicensedDescriptor(systemId);
            if (nonLicDesc != null) {
                state = ResourceState.INVALID;
            } else if (desc == null) {
                state = ResourceState.INACTIVE;
            } else if (systemId.equals("04")) {
                if (humanResCount >= availHumanRes) {
                    state = ResourceState.INVALID;
                } else {
                    state = ResourceState.OFFLINE;
                    ++humanResCount;
                }
            } else if (sysResCount >= availSystemRes) {
                state = ResourceState.INVALID;
            } else {
                state = ResourceState.OFFLINE;
                ++sysResCount;
            }
            resource.setOperationalState(state);
            logger.debug((Object)(String.valueOf(resource.getName()) + " set to " + state.getStateName()));
            if (this.context.manager.state == ResourceManager.State.ONLINE) {
                resource = resDAI.update(resource);
            }
            ResourceContainer resContainer = new ResourceContainer(resource, this.context.manager);
            this.context.resources.put(resource.getId(), resContainer);
        }
        this.context.setNumOfActiveHumanResources(humanResCount);
        this.context.setNumOfActiveSystemResources(sysResCount);
    }

    private void cacheResourceGroups() {
        logger.debug((Object)"ResourceManagerLifeCycleManager.cacheResourceGroups()");
        ResourceGroupDAI rgDAI = this.context.daoFactory.getResourceGroupDAO();
        ResourceDAI resDAI = this.context.daoFactory.getResourceDAO();
        List<ResourceGroup> resourceGroupList = rgDAI.findAll();
        if (this.context.manager.state == ResourceManager.State.ONLINE) {
            for (ResourceGroup resourceGroup : resourceGroupList) {
                HashSet<Resource> resources = new HashSet<Resource>(resourceGroup.getResources());
                for (Resource resource : resources) {
                    if (resource.getActive()) continue;
                    resourceGroup.removeResource(resource);
                    Resource storedResource = (Resource)resDAI.findByKey(resource.getId());
                    storedResource.removeAllResourceGroups();
                    resDAI.update(storedResource);
                }
            }
            for (ResourceGroup rg : resourceGroupList) {
                if (this.context.pluginManager.getResourceGroupDescriptor(rg.getName()) != null) continue;
                this.context.pluginManager.notifyMissingResourceGroup(rg.getName(), rg.getResourceType().getSystemId());
            }
            List<ResourceGroupDescriptor> resourceGroupDescList = this.context.pluginManager.getResourceGroupDescriptors();
            if (resourceGroupDescList != null) {
                for (ResourceGroupDescriptor descriptor : resourceGroupDescList) {
                    ResourceGroup rg;
                    ResourceType resourceType = this.getResourceType(descriptor.getSystemId());
                    if (resourceType == null) {
                        String message = "Resource Type for System ID: " + descriptor.getSystemId() + " is inactive or not found in database";
                        this.context.pluginManager.notifyUnacceptedResourceGroupDescriptor(descriptor, message);
                    }
                    if ((rg = this.getResourceGroup(descriptor.getName(), resourceGroupList)) == null) {
                        if (resourceType == null) continue;
                        IAuthorizationManager auth = (IAuthorizationManager)ServiceRegistry.getDefault().lookup(IAuthorizationManager.class);
                        int protectionKeyID = auth.getProtectionKeyIDForName(descriptor.getAccessLevel(), true);
                        logger.debug((Object)("Creating resource group: " + descriptor.getName() + " in database"));
                        resourceGroupList.add(rgDAI.create(this.convertToResourceGroup(descriptor, resourceType, protectionKeyID)));
                        continue;
                    }
                    Collection<String> validationFailureMessages = this.validateUpdate(descriptor, resourceType, rg);
                    if (validationFailureMessages.size() > 0) {
                        this.context.pluginManager.notifyUnacceptedResourceGroupDescriptor(descriptor, validationFailureMessages);
                        continue;
                    }
                    this.copy(descriptor, rg);
                    logger.debug((Object)("Updating resource group: " + rg.getName() + " in database"));
                    rgDAI.update(rg);
                }
            }
        }
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        for (ResourceGroup resourceGroup : resourceGroupList) {
            ResourceGroupContainer rgContainer = new ResourceGroupContainer(resourceGroup, this.context.manager);
            this.context.resourceGroups.put(resourceGroup.getId(), rgContainer);
            if (!this.isValidPlugin(resourceGroup)) continue;
            this.registerMBean(server, rgContainer);
        }
    }

    private ResourceType createResourceType(ResourceTypeDescriptor desc, ResourceType match) {
        ResourceType result = match;
        if (match == null) {
            result = new ResourceType();
        }
        result.setName(desc.getName());
        result.setSystemId(desc.getSystemId());
        if (match != null) {
            String msg;
            ManagementDescriptor mgmt = desc.getManagement();
            if (mgmt.getConnectionType() != result.getConnectionType()) {
                msg = "The Connection Type for: " + desc.getSystemId() + " - " + desc.getName() + " is being changed from " + (Object)((Object)result.getConnectionType()) + " to " + (Object)((Object)mgmt.getConnectionType()) + ", current resources will have invalid connection strings.";
                logger.warn((Object)msg);
            }
            if (mgmt.getHeartbeatConnectionType() != result.getHeartbeatConnectionType()) {
                msg = "The Heartbeat Connection Type for: " + desc.getSystemId() + " - " + desc.getName() + " is being changed from " + (Object)((Object)result.getConnectionType()) + " to " + (Object)((Object)mgmt.getConnectionType()) + ", current resources will have invalid heartbeat connection strings.";
                logger.warn((Object)msg);
            }
        }
        result.setConnectionType(desc.getManagement().getConnectionType());
        result.setHeartbeatConnectionType(desc.getManagement().getHeartbeatConnectionType());
        return result;
    }

    private Collection<String> validateUpdate(ResourceGroupDescriptor descriptor, ResourceType resourceType, ResourceGroup rg) {
        ArrayList<String> validationFailureMessages = new ArrayList<String>();
        if (rg.getResources() != null && !rg.getResources().isEmpty()) {
            IAuthorizationManager auth = (IAuthorizationManager)ServiceRegistry.getDefault().lookup(IAuthorizationManager.class);
            int protectionKeyID = auth.getProtectionKeyIDForName(descriptor.getAccessLevel(), false);
            if (protectionKeyID == -1 || protectionKeyID != rg.getProtectionKeyId()) {
                validationFailureMessages.add("Access Level cannot be changed | Reason: Resource Group has Resources.");
            }
            boolean funTypeEquality = false;
            if (rg.getFunctionalType() == null && descriptor.getFunctionalType() == null) {
                funTypeEquality = true;
            } else if (rg.getFunctionalType() != null && descriptor.getFunctionalType() != null && rg.getFunctionalType().equals(descriptor.getFunctionalType())) {
                funTypeEquality = true;
            }
            if (!funTypeEquality) {
                validationFailureMessages.add("Functional Type cannot be changed | Reason: Resource Group has Resources.");
            }
        }
        if (!rg.getResourceType().equals(resourceType)) {
            validationFailureMessages.add("Resource Type cannot be changed.");
        }
        return validationFailureMessages;
    }

    private ResourceGroup getResourceGroup(String name, List<ResourceGroup> resourceGroupList) {
        for (ResourceGroup resourceGroup : resourceGroupList) {
            if (resourceGroup.getName() == null || !resourceGroup.getName().equals(name)) continue;
            return resourceGroup;
        }
        return null;
    }

    private void copy(ResourceGroupDescriptor pluginsRGDesc, ResourceGroup dbRG) {
        if (pluginsRGDesc.getIsInternallyAcquired() != null) {
            dbRG.setInternallyAcquired(pluginsRGDesc.getIsInternallyAcquired());
        }
        if (pluginsRGDesc.getAccessLevel() != null) {
            IAuthorizationManager auth = (IAuthorizationManager)ServiceRegistry.getDefault().lookup(IAuthorizationManager.class);
            int protectionKeyID = auth.getProtectionKeyIDForName(pluginsRGDesc.getAccessLevel(), true);
            dbRG.setProtectionKeyId(protectionKeyID);
        }
        dbRG.setFunctionalType(pluginsRGDesc.getFunctionalType());
    }

    private boolean isValidPlugin(ResourceGroup group) {
        for (FailureDescriptor descriptor : this.context.pluginManager.getUnacceptedResourceGroupDescriptors()) {
            if (!descriptor.getName().equals(group.getName())) continue;
            return false;
        }
        for (FailureDescriptor descriptor : this.context.pluginManager.getMissingResourceGroups()) {
            if (!descriptor.getName().equals(group.getName())) continue;
            return false;
        }
        return true;
    }

    private ResourceType getResourceType(String systemId) {
        if (this.context.resourceTypes != null && this.context.resourceTypes.values() != null) {
            for (ResourceType resourceType : this.context.resourceTypes.values()) {
                if (resourceType == null || resourceType.getSystemId() == null || !resourceType.getSystemId().equals(systemId)) continue;
                return resourceType;
            }
        }
        return null;
    }

    private ResourceGroup convertToResourceGroup(ResourceGroupDescriptor descriptor, ResourceType resourceType, int protectionKeyID) {
        ResourceGroup rg = new ResourceGroup();
        rg.setName(descriptor.getName());
        rg.setResourceType(resourceType);
        rg.setFunctionalType(descriptor.getFunctionalType());
        rg.setProtectionKeyId(protectionKeyID);
        rg.setInternallyAcquired(descriptor.getIsInternallyAcquired());
        return rg;
    }

    private void registerMBean(MBeanServer server, ResourceGroupContainer container) {
        ResourceGroupQueueSampler monitor = new ResourceGroupQueueSampler(container);
        String name = container.getResourceGroup().getName();
        try {
            StandardMBean mbean = new StandardMBean(monitor, IQueueMonitor.class);
            server.registerMBean(mbean, new ObjectName(MBEAN_NAME + name));
        }
        catch (JMException e) {
            logger.warn((Object)("MBean registration for group " + name + " failed"));
        }
    }

    private void unregisterMBean(MBeanServer server, ResourceGroupContainer container) {
        try {
            server.unregisterMBean(new ObjectName(MBEAN_NAME + container.getResourceGroup().getName()));
        }
        catch (JMException jMException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ArrayList<ResourceGroupContainer> resourceGroupList = null;
        ResourceManager resourceManager = this.context.manager;
        synchronized (resourceManager) {
            if (!this.isInitialized) {
                return;
            }
            logger.debug((Object)"Shutting down the Resource Manager...");
            logger.debug((Object)"Unregistering with the Mediator.");
            this.context.mediator.unregister((IColleague)this.context.manager);
            logger.debug((Object)"Changing the Operational State of all Resources to Offline.");
            for (ResourceContainer container : this.context.resources.values()) {
                ResourceState opState = container.getResource().getOperationalState();
                if (ResourceState.OFFLINE == opState || ResourceState.INACTIVE == opState || ResourceState.INVALID == opState) continue;
                this.context.stateManager.takeResourceOffline(container);
                this.context.storeResource(container.getResource().getId());
            }
            logger.debug((Object)"Stopping all Resource Group Container Threads.");
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            for (ResourceGroupContainer rgContainer : this.context.resourceGroups.values()) {
                rgContainer.stop();
                if (!this.isValidPlugin(rgContainer.getResourceGroup())) continue;
                this.unregisterMBean(server, rgContainer);
            }
            resourceGroupList = new ArrayList<ResourceGroupContainer>();
            resourceGroupList.addAll(this.context.resourceGroups.values());
            logger.debug((Object)"Clearing all Resource Manager Cache.");
            this.context.resources.clear();
            this.context.resourceGroups.clear();
            this.context.resourceTypes.clear();
            this.isInitialized = false;
        }
        for (ResourceGroupContainer rgContainer : resourceGroupList) {
            this.shutdownQueueThread(rgContainer);
        }
        logger.info((Object)"Finished shutting down the Resource Manager.");
    }

    private void shutdownQueueThread(ResourceGroupContainer container) {
        WorkerThread thread = container.getWorkerThread();
        long groupId = container.getResourceGroup().getId();
        int retryCount = 0;
        while (thread.isAlive() && retryCount < 3) {
            ++retryCount;
            container.notifyQueue();
            try {
                thread.join(30000L);
            }
            catch (InterruptedException ex) {
                String msg = "Interrupted while waiting for the Worker Thread for group: " + groupId + " to terminate.";
                logger.error((Object)msg, (Throwable)ex);
            }
        }
        if (thread.isAlive()) {
            logger.error((Object)("Failed to shutdown the Queue Processing Thread for Resource Group #" + groupId));
        }
    }
}

