/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.entities;

import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceEntity;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroupQueueItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class ResourceGroupQueue
implements ResourceEntity,
Iterable<ResourceGroupQueueItem> {
    private static final long serialVersionUID = -5418538065738959637L;
    private ResourceGroup parentGroup;
    private transient ResourceGroupQueueItem current;
    private int max;
    private long totalDelay;
    private int added;
    private int removed;
    private List<ResourceGroupQueueItem> queue = new ArrayList<ResourceGroupQueueItem>();

    public ResourceGroupQueue() {
    }

    public ResourceGroupQueue(ResourceGroup parent) {
        this.parentGroup = parent;
    }

    public ResourceGroup getResourceGroup() {
        return this.parentGroup;
    }

    public void setResourceGroup(ResourceGroup resourceGroup) {
        this.parentGroup = resourceGroup;
        if (this.queue != null) {
            for (ResourceGroupQueueItem item : this.queue) {
                if (item == null) continue;
                item.setResourceGroup(resourceGroup);
            }
        }
    }

    public ResourceGroupQueueItem getCurrent() {
        return this.current;
    }

    public void setCurrent(ResourceGroupQueueItem current) {
        this.current = current;
    }

    public int getMax() {
        return this.max;
    }

    public int getAdded() {
        return this.added;
    }

    public int getRemoved() {
        return this.removed;
    }

    public long getTotalDelay() {
        return this.totalDelay;
    }

    @Deprecated
    public List<ResourceGroupQueueItem> getQueuedItems() {
        return this.queue;
    }

    @Deprecated
    public void setQueuedItems(List<ResourceGroupQueueItem> queuedItems) {
        if (queuedItems == null) {
            queuedItems = new ArrayList<ResourceGroupQueueItem>();
        }
        this.queue = queuedItems;
    }

    public int add(ResourceGroupQueueItem queueItem) {
        if (queueItem == null) {
            String msg = "Attempting to add null item to the queue for " + this.getGroupName() + ", ignoring null item.";
            throw new IllegalArgumentException(msg);
        }
        int index = this.getInsertIndex(queueItem);
        this.addItem(index, queueItem);
        return index;
    }

    public void add(int index, ResourceGroupQueueItem queueItem) {
        ResourceGroupQueueItem itemBelow;
        ResourceGroupQueueItem itemAbove;
        if (queueItem == null) {
            String msg = "Attempting to add null item to the queue for " + this.getGroupName() + ", ignoring null item.";
            throw new IllegalArgumentException(msg);
        }
        QueueItemComparator comparator = new QueueItemComparator();
        comparator.useDateEquals = true;
        if (index > 0 && comparator.compare(itemAbove = this.queue.get(index - 1), queueItem) > 0) {
            String msg = "Cannot insert item in queue since it violates queue order.";
            throw new IllegalArgumentException(msg);
        }
        if (index < this.size() && comparator.compare(queueItem, itemBelow = this.queue.get(index)) > 0) {
            String msg = "Cannot insert item in queue since it violates queue order.";
            throw new IllegalArgumentException(msg);
        }
        this.addItem(index, queueItem);
    }

    private void addItem(int index, ResourceGroupQueueItem queueItem) {
        queueItem.setResourceGroup(this.parentGroup);
        this.queue.add(index, queueItem);
        ++this.added;
        if (this.max < this.queue.size()) {
            this.max = this.queue.size();
        }
    }

    private int getInsertIndex(ResourceGroupQueueItem queueItem) {
        int insertIndex = Collections.binarySearch(this.queue, queueItem, new QueueItemComparator());
        return -(insertIndex + 1);
    }

    public boolean remove(ResourceGroupQueueItem queueItem) {
        if (this.queue.remove(queueItem)) {
            this.totalDelay += System.currentTimeMillis() - queueItem.getQueuedDate().getTime();
            ++this.removed;
            return true;
        }
        return false;
    }

    public void clear() {
        this.queue.clear();
    }

    public ResourceGroupQueueItem get(int index) {
        return this.queue.get(index);
    }

    public boolean contains(ResourceGroupQueueItem queueItem) {
        return this.queue.contains(queueItem);
    }

    public int indexOf(ResourceGroupQueueItem queueItem) {
        return this.queue.indexOf(queueItem);
    }

    public ResourceGroupQueueItem findItem(long tokenId) {
        for (ResourceGroupQueueItem item : this.queue) {
            if (item.getTokenId() != tokenId) continue;
            return item;
        }
        return null;
    }

    public ResourceGroupQueueItem findItemByKey(long queueItemId) {
        for (ResourceGroupQueueItem item : this.queue) {
            if (item.getId() != queueItemId) continue;
            return item;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public Iterator<ResourceGroupQueueItem> iterator() {
        return this.queue.iterator();
    }

    public int size() {
        return this.queue.size();
    }

    @Override
    public Object clone() {
        ResourceGroupQueue clone = null;
        try {
            clone = (ResourceGroupQueue)super.clone();
            if (this.queue != null) {
                clone.queue = new ArrayList<ResourceGroupQueueItem>();
                for (ResourceGroupQueueItem item : this.queue) {
                    ResourceGroupQueueItem cloneItem = (ResourceGroupQueueItem)item.clone();
                    clone.queue.add(cloneItem);
                }
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    private String getGroupName() {
        String groupName = null;
        groupName = this.parentGroup == null ? "unknown resource group" : "resource group [" + this.parentGroup.getId() + "]";
        return groupName;
    }

    private static final class QueueItemComparator
    implements Comparator<ResourceGroupQueueItem> {
        private boolean useDateEquals = false;

        private QueueItemComparator() {
        }

        @Override
        public int compare(ResourceGroupQueueItem i1, ResourceGroupQueueItem i2) {
            ProcessPriority p1 = i1.getPriority();
            ProcessPriority p2 = i2.getPriority();
            int diff = p2.compareTo((Enum)p1);
            if (diff != 0) {
                return diff;
            }
            diff = i1.getQueueOrderDate().compareTo(i2.getQueueOrderDate());
            if (diff != 0) {
                return diff;
            }
            return this.useDateEquals ? 0 : -1;
        }
    }
}

