/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.search;

import com.tandbergtv.workflow.driver.search.SearchOperator;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;

public class ValueParameter
extends SearchParameterBase {
    private Object value = null;
    private SearchOperator operator = null;

    public ValueParameter(String name) {
        this(name, SearchType.STRING, SearchOperator.EQUAL);
    }

    public ValueParameter(String name, SearchType type) {
        super(name, type);
        this.setOperator(SearchOperator.EQUAL);
    }

    public ValueParameter(String name, SearchType type, boolean isVariable) {
        super(name, type, isVariable);
        this.setOperator(SearchOperator.EQUAL);
    }

    public ValueParameter(String name, SearchType type, boolean isVariable, Object value) {
        super(name, type, isVariable);
        this.setOperator(SearchOperator.EQUAL);
        this.setValue(value);
    }

    public ValueParameter(String name, SearchType type, SearchOperator operator) {
        this(name, type, null, operator);
    }

    public ValueParameter(String name, SearchType type, Object value) {
        super(name, type);
        this.setValue(value);
        this.setOperator(SearchOperator.EQUAL);
    }

    public ValueParameter(String name, SearchType type, boolean isVariable, SearchOperator operator) {
        super(name, type, isVariable);
        this.setOperator(operator);
    }

    public ValueParameter(String name, SearchType type, Object value, SearchOperator operator) {
        this(name, type, false, value, operator);
    }

    public ValueParameter(String name, SearchType type, boolean isVariable, Object value, SearchOperator operator) {
        super(name, type, isVariable);
        this.value = value;
        this.setOperator(operator);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public SearchOperator getOperator() {
        return this.operator;
    }

    public void setOperator(SearchOperator operator) {
        if (operator == SearchOperator.IN || operator == SearchOperator.NOTIN || operator == SearchOperator.LIKE && this.getFieldType() != SearchType.STRING) {
            throw new RuntimeException("Search operator is invalid: " + (Object)((Object)operator));
        }
        this.operator = operator;
    }

    @Override
    public String getPredicate() {
        if (this.value == null && this.getOperator() == SearchOperator.EQUAL) {
            return " is null";
        }
        if (this.value == null && this.getOperator() == SearchOperator.NOTEQUAL) {
            return " is not null";
        }
        String operator = this.getOperatorString();
        if (SearchOperator.EQUAL == this.getOperator() && this.getFieldType() == SearchType.STRING) {
            return operator + "'" + this.value + "'";
        }
        if (SearchOperator.NOTEQUAL == this.getOperator() && this.getFieldType() == SearchType.STRING) {
            return operator + "'" + this.value + "'";
        }
        if (SearchOperator.LIKE == this.getOperator() && this.getFieldType() == SearchType.STRING) {
            return operator + "'%" + this.value + "%'";
        }
        if (this.getFieldType() == SearchType.DATE) {
            return operator + "to_date('" + this.value + "','" + "yyyy-MM-dd" + "' )";
        }
        if (SearchOperator.STARTSWITH == this.getOperator() && this.getFieldType() == SearchType.STRING) {
            return operator + "'" + this.value + "%'";
        }
        if (SearchOperator.ENDSWITH == this.getOperator() && this.getFieldType() == SearchType.STRING) {
            return operator + "'%" + this.value + "'";
        }
        if (SearchOperator.CONTAINS == this.getOperator() && this.getFieldType() == SearchType.STRING) {
            return operator + "'%" + this.value + "%'";
        }
        if (SearchOperator.ISEMPTY == this.getOperator() && this.getFieldType() == SearchType.STRING) {
            return "not" + operator + "'" + this.value + "%'";
        }
        if (SearchOperator.ISNOTEMPTY == this.getOperator() && this.getFieldType() == SearchType.STRING) {
            return operator + "'" + this.value + "%'";
        }
        return operator + this.value;
    }

    private String getOperatorString() {
        switch (this.operator) {
            case EQUAL: {
                return " = ";
            }
            case GREATERTHAN: {
                return " > ";
            }
            case LESSTHAN: {
                return " < ";
            }
            case NOTEQUAL: {
                return " != ";
            }
            case LIKE: {
                return " LIKE ";
            }
            case GREATERTHANEQUAL: {
                return " >= ";
            }
            case LESSTHANEQUAL: {
                return " <= ";
            }
            case STARTSWITH: {
                return " LIKE ";
            }
            case ENDSWITH: {
                return " LIKE ";
            }
            case CONTAINS: {
                return " LIKE ";
            }
            case ISEMPTY: {
                return " LIKE ";
            }
            case ISNOTEMPTY: {
                return " LIKE ";
            }
        }
        return null;
    }
}

