/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.search;

import com.tandbergtv.workflow.driver.search.SearchOperator;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import java.util.ArrayList;
import java.util.List;

public class ListParameter
extends SearchParameterBase {
    private List values;
    private SearchOperator operator;

    public ListParameter(String name) {
        this(name, SearchType.STRING);
    }

    public ListParameter(String name, SearchType type) {
        this(name, type, SearchOperator.IN);
    }

    public ListParameter(String name, SearchType type, boolean isVariable) {
        this(name, type, SearchOperator.IN, isVariable);
    }

    public ListParameter(String name, SearchType type, SearchOperator operator) {
        this(name, type, operator, false);
    }

    public ListParameter(String name, boolean ignoreCase, SearchType type, SearchOperator operator) {
        this(name, type, operator, false);
        this.setIgnoreCase(ignoreCase);
    }

    public ListParameter(String name, SearchType type, SearchOperator operator, boolean isVariable) {
        super(name, type, isVariable);
        this.setOperator(operator);
    }

    public List getValues() {
        return this.values;
    }

    public void setValues(List values) {
        this.values = values;
    }

    public SearchOperator getOperator() {
        return this.operator;
    }

    public void setOperator(SearchOperator operator) {
        if (operator != SearchOperator.IN && operator != SearchOperator.NOTIN) {
            throw new RuntimeException("Search operator is invalid: " + (Object)((Object)operator));
        }
        this.operator = operator;
    }

    public void addValue(Object val) {
        if (this.values == null) {
            this.values = new ArrayList();
        }
        this.values.add(val);
    }

    public void addValues(Object ... values) {
        if (this.values == null) {
            this.values = new ArrayList();
        }
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            this.values.add(value);
            ++n2;
        }
    }

    @Override
    public String getPredicate() {
        String result = null;
        String operatorperfix = this.operator == SearchOperator.IN ? " IN (" : " NOT IN (";
        for (Object val : this.values) {
            result = result == null ? String.valueOf(operatorperfix) + this.getFormattedValue(val) : String.valueOf(result) + "," + this.getFormattedValue(val);
        }
        if (result != null) {
            result = String.valueOf(result) + ")";
        }
        return result;
    }

    private String getFormattedValue(Object val) {
        if (this.getFieldType() == SearchType.STRING) {
            return "'" + (this.ignoreCase ? val.toString().toLowerCase() : val) + "'";
        }
        if (this.getFieldType() == SearchType.DATE) {
            return "to_date('" + val + "','" + "yyyy-MM-dd" + "' )";
        }
        return val.toString();
    }
}

