/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.util;

import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class SearchCriteria
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int startingRecordNumber = 0;
    private int recordsCount = 0;
    private List<SearchParameterBase> searchList = new ArrayList<SearchParameterBase>();

    public SearchCriteria() {
    }

    public SearchCriteria(SearchCriteria criteria) {
        this();
        if (criteria == null) {
            throw new IllegalArgumentException("Search criteria cannot be null");
        }
        this.searchList = (List)((ArrayList)criteria.getSearchList()).clone();
    }

    public int getRecordsCount() {
        return this.recordsCount;
    }

    public void setRecordsCount(int recordsCount) {
        this.recordsCount = recordsCount;
    }

    public List<SearchParameterBase> getSearchList() {
        return this.searchList;
    }

    public int getStartingRecordNumber() {
        return this.startingRecordNumber;
    }

    public void setStartingRecordNumber(int startingRecordNumber) {
        this.startingRecordNumber = startingRecordNumber;
    }

    public void addParameter(SearchParameterBase parameter) {
        this.searchList.add(parameter);
    }

    public void addParameters(List<SearchParameterBase> parameters) {
        this.searchList.addAll(parameters);
    }

    public SearchParameterBase removeParameter(String fieldName) {
        SearchParameterBase param = this.getParameter(fieldName);
        if (param == null) {
            return null;
        }
        this.searchList.remove(param);
        return param;
    }

    public SearchParameterBase getParameter(String fieldName) {
        for (SearchParameterBase param : this.searchList) {
            if (!param.getFieldName().equals(fieldName)) continue;
            return param;
        }
        return null;
    }

    public <T> T getParameter(String fieldName, Class T) {
        for (SearchParameterBase param : this.searchList) {
            if (!param.getFieldName().equals(fieldName) || !param.getClass().isAssignableFrom(T)) continue;
            return (T)param;
        }
        return null;
    }

    public int count() {
        return this.searchList.size();
    }

    public String toString() {
        StringBuilder sbSearchCriteria = new StringBuilder();
        for (SearchParameterBase param : this.searchList) {
            if (param.getSortingOrder() == null) continue;
            sbSearchCriteria.append("Sorting Column Name-->" + param.getFieldName());
            sbSearchCriteria.append(" ::Sorting Order-->" + (Object)((Object)param.getSortingOrder()));
        }
        sbSearchCriteria.append(" ::Starting Record Number-->" + this.getStartingRecordNumber());
        sbSearchCriteria.append(" ::Records Count-->" + this.getRecordsCount());
        return sbSearchCriteria.toString();
    }
}

